<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

class AreaNegocioController extends Controller
{
    use Autenticable;

    public function index(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $areas = DB::table('areanegocio')
            ->select('ID_AREANEGOCIO as id', 'NOMBRE_AREANEGOCIO as nombre')
            ->whereRaw('ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->where('ESTADO', '=', 1)
            ->get();

        return response()->json($areas);
    }
}
