<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;
use Logger;

use App\Models\Cotizacion;
use App\Models\NotaVenta;
use App\Models\OrdenCompra;
use App\Models\Boleta;
use App\Models\Boleta2;
use App\Models\Woopy;
use App\Models\Ecomerce;
use App\Models\Pedido;
use App\Models\Prefactura;
use App\Models\Factura;
use App\Models\NotaCredito;
use App\Models\GuiaDespacho;
use App\Models\SolicitudCompra;

use App\Api\AbstrahereApi;

use App\Traits\Abstrahere;
use App\Traits\Foliable;
use App\Traits\Documentable;
use App\Models\Producto;
use App\Models\Cliente;
use App\Models\Bodega;




class FacturacionController extends Controller
{
    use Autenticable;
    use Foliable;
    use Abstrahere;
    use Documentable;

    const BOLETA_AFECTA = 39;
    const BOLETA_EXENTA = 41;

    const ORDENCOMPRA = 801;

    const VALE_COMPROBANTE = 48;

    const FACTURA_AFECTA = 33;
    const FACTURA_EXENTA = 34;


    public function generaTxtXml(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        

        foreach($datos as $doc) {
            $respuesta = [];
            try{
                $this->validateArray($request, $doc, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Fecha' => 'required',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.Razon' => 'required',
                    'Encabezado.TipoDocumento' => 'required|integer|in:39,33,34',
                    'Encabezado.Folio' => 'required|numeric|min:0',
                    'Encabezado.Observacion' => 'sometimes|required|max:255',
                    'Encabezado.Direccion' => 'required',
                    'Encabezado.Comuna' => 'required',
                    'Encabezado.Ciudad' => 'required',


                    'Totales' => 'required|array',
                    'Totales.Exento' => 'sometimes|required|integer|min:0',
                    'Totales.Neto' => 'sometimes|required|integer|min:0',
                    'Totales.Iva' => 'sometimes|required|integer|min:1',
                    'Totales.Total' => 'required|integer|min:1',


                    //'Encabezado.MontoNeto' => 'required|numeric|min:0',
                    //'Encabezado.MontoExento' => 'required|numeric|min:0',
                    //'Encabezado.Descuento' => 'required|numeric|min:0',
                    //'Encabezado.AreaNegocio' => 'required|numeric',
                    //'Encabezado.CondicionPago' => 'required|integer',   //Forma de Pago
                    //'Encabezado.Vendedor' => 'required|rut',    //Vendedor

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'sometimes|required',
                    'Detalle.*.Detalle' => 'required',
                    'Detalle.*.DetalleLargo' => 'sometimes|required',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:0',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',



                ]);
            }catch(Exception $e) {
                $respuestas[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            if (empty($doc['Encabezado']['Folio']) ) {
                // code...
                $folio = $this->obtenFolio(
                    $usuario->rut_empresa,
                    $doc['Encabezado']['TipoDocumento']
                );
                if(is_null($folio)) {
                    $respuestas[$item] = ['mensaje' => 'No se pudo obtener folio item #'.$item.'.'];
                    continue;
                }
            }else{
                $folio = $doc['Encabezado']['Folio'];
            }


            $emisor = $this->obtenDatosEmisor($usuario->rut_empresa);

            //dd($emisor);

            //valida totales
            $totalAfecto = 0;
            $totalExento = 0;

            foreach($doc['Detalle'] as $detalle){
                $cantidad = $detalle['Cantidad'];
                $precio = $detalle['Precio'];

                if ($detalle['Afecto'] == true) {
                    // code...
                    $totalAfecto += $cantidad * $precio;
                }else{
                    $totalExento += $cantidad * $precio;
                }
            }

            if($doc['Totales']['Neto'] != $totalAfecto){
                $respuestas[$item] = ['mensaje' => 'Suma neto '.$doc['Totales']['Neto'].' NO cuadra.'];
                continue;
            }
            if($doc['Totales']['Exento'] != $totalExento){
                $respuestas[$item] = ['mensaje' => 'Suma exento '.$doc['Totales']['Exento'].' NO cuadra.'];
                continue;
            }


            //dd($emisor->razon);
            $datos_xml = [
                'TipoDTE' => $doc['Encabezado']['TipoDocumento'],

                'Folio' => $folio,
                'RutEmisor' => trim(strtoupper($usuario->rut_empresa)),
                'RznSoc' => $emisor->razon,
                'GiroEmis' => $emisor->giro1,
                'Telefono' => $emisor->telefono,
                'Acteco' => $emisor->clavesii,
                'DirOrigen' => $emisor->direccion,
                'CmnaOrigen' => $emisor->comuna,
                'CiudadOrigen' => $emisor->ciudad,
                'RUTRecep' => trim(strtoupper($doc['Encabezado']['Receptor'])),
                'RznSocRecep' => $doc['Encabezado']['Razon'],
                'DirRecep' => $doc['Encabezado']['Direccion'],
                'CmnaRecep' => $doc['Encabezado']['Comuna'],
                'CiudadRecep' => $doc['Encabezado']['Ciudad'],

                'MntNeto' => round(($doc['Totales']['Neto']), 0, PHP_ROUND_HALF_UP),
                'MntExento' => round(($doc['Totales']['Exento']), 0, PHP_ROUND_HALF_UP),
                'MntIva' => round(($doc['Totales']['Iva']), 0, PHP_ROUND_HALF_UP),
                'MntTotal' => round(($doc['Totales']['Total']), 0, PHP_ROUND_HALF_UP),
                'Detalles' => [],
            ];

            //generar xml
            $xml = $this->generaXmlIntegracion([
                'Rut' => $usuario->rut_empresa,
                'Productivo' => env('AMBIENTE_SII'),
                'Operacion' => 'procesadte',
                'AsignarFolio' => '0',
                'BoletaBasica' => $this->generaXmlDTE($datos_xml,$doc['Detalle']),
                'Adicionales' => $this->generaXmlAdicionales($doc['Adicional']),
            ]);

            $respuesta = $this->integrar($xml);
            $respuestas[$item] = simplexml_load_string($respuesta->IntegracionResult);

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuestas[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuestas);
    }

    public function ingresarPrefacturaV2(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        /*Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );*/

        foreach($datos as $doc) {
            $respuesta = [];
            try{
                $this->validateArray($request, $doc, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.AreaNegocio' => 'required|numeric',
                    'Encabezado.FormaPagoPrefactura' => 'required|numeric',
                    'Encabezado.Observacion' => 'sometimes|required|max:255',
                    //'Encabezado.Direccion' => 'sometimes|required|max:255',

                    'Totales.MontoNeto' => 'required|numeric|min:0',
                    'Totales.MontoExento' => 'required|numeric|min:0',


                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:0',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',
                    'Detalle.*.Bodega' => 'required|integer',

                    //'Adicional.Uno' => 'required|integer', //Forma de Pago
                    //'Adicional.Dos' => 'required|rut',//Vendedor
                    'Adicional.Treinta' => 'sometimes|required|numeric|min:0', //donacion
                ]);
            }catch(Exception $e) {
                $respuestas[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            $emision_prefactura = new Prefactura(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $doc['Encabezado']['Receptor'],
                $doc['Encabezado']['AreaNegocio'],
                $doc['Encabezado']['FormaPagoPrefactura'],
                $doc['Encabezado']['Observacion'],
                $doc['Totales']['MontoNeto'],
                $doc['Totales']['MontoExento'],
                $doc['Detalle']
                //$doc['Adicional']
            );

            $respuestas[$item] = $emision_prefactura->ingresar();

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuestas[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuestas);
    }

    /*public function ingresarNupyPro(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        foreach($datos as $doc) {
            $respuesta = [];
            try{
                $this->validateArray($request, $doc, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.AreaNegocio' => 'required|numeric',
                    'Encabezado.FormaPagoPrefactura' => 'required|numeric',
                    'Encabezado.Observacion' => 'sometimes|required|max:255',
                    //'Encabezado.Direccion' => 'sometimes|required|max:255',

                    'Totales.MontoNeto' => 'required|numeric|min:0',
                    'Totales.MontoExento' => 'required|numeric|min:0',


                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:0',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',
                    'Detalle.*.Bodega' => 'required|integer',

                    //'Adicional.Uno' => 'required|integer', //Forma de Pago
                    //'Adicional.Dos' => 'required|rut',//Vendedor
                    'Adicional.Treinta' => 'sometimes|required|numeric|min:0', //donacion
                ]);
            }catch(Exception $e) {
                $respuestas[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            $emision_prefactura = new Prefactura(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $doc['Encabezado']['Receptor'],
                $doc['Encabezado']['AreaNegocio'],
                $doc['Encabezado']['FormaPagoPrefactura'],
                $doc['Encabezado']['Observacion'],

                $doc['Totales']['MontoNeto'],
                $doc['Totales']['MontoExento'],

                $doc['Detalle'],
                //$doc['Adicional']
            );

            $respuestas[$item] = $emision_prefactura->ingresar();

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                json_encode($doc),
                $respuestas[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuestas);
    }
    */
    public function ingresarSolicitudCompra(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        /*Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );*/

        foreach($datos as $solicitudCompra) {
            $respuesta = [];
            try{
                $this->validateArray($request, $solicitudCompra, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Fecha' => 'required',
                    'Encabezado.Generica' => 'required',
                    'Encabezado.FechaEntrega' => 'required',
                    'Encabezado.Status' => 'required',
                    'Encabezado.DescripcionCorta' => 'required',
                    'Encabezado.Solicitado' => 'required',
                    'Encabezado.Prioridad' => 'required|integer|in:1,2,3,7',

                    'Detalle' => 'required|array',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descripcion' => 'required',
                    'Detalle.*.Observacion' => 'sometimes|required',
                    'Detalle.*.Unidad' => 'required|integer|min:1',
                    'Detalle.*.Codigo' => 'required',

                ]);
            }catch(Exception $e) {
                $respuestas[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            $solicitud_de_compra = new SolicitudCompra(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,

                $solicitudCompra['Encabezado']['Fecha'],
                $solicitudCompra['Encabezado']['Generica'],
                $solicitudCompra['Encabezado']['FechaEntrega'],
                $solicitudCompra['Encabezado']['Status'],
                $solicitudCompra['Encabezado']['DescripcionCorta'],
                $solicitudCompra['Encabezado']['Solicitado'],
                $solicitudCompra['Encabezado']['Prioridad'],

                $solicitudCompra['Detalle']
            );

            $respuestas[$item] = $solicitud_de_compra->ingresarSolicitudCompra();

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuestas[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuestas);
    }

    public function ingresarCotizacion(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        foreach($datos as $cotizacion) {
            $respuesta = [];
            try{
                $this->validateArray($request, $cotizacion, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.MontoNeto' => 'required|numeric|min:0',
                    'Encabezado.MontoExento' => 'required|numeric|min:0',
                    'Encabezado.MontoNoFacturable' => 'sometimes|numeric|min:0',
                    'Encabezado.Descuento' => 'required|numeric|min:0',
                    'Encabezado.TipoDocumento' => 'required|integer|in:'.Cotizacion::COTIZACION,
                    'Encabezado.Folio' => 'required|numeric|min:0',
                    'Encabezado.AreaNegocio' => 'required|numeric',
                    'Encabezado.CondicionPago' => 'required|integer',   //Forma de Pago
                    'Encabezado.Vendedor' => 'required|rut',    //Vendedor
                    'Encabezado.Observacion' => 'sometimes|required|max:255',
                    'Encabezado.Direccion' => 'sometimes|required|integer',

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:0',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',

                    'Adicional.Treinta' => 'sometimes|required|numeric|min:0', //donacion

                ]);
            }catch(Exception $e) {
                $respuestas[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            $cotiza = new Cotizacion(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $cotizacion['Encabezado']['Receptor'],
                $cotizacion['Encabezado']['MontoNeto'],
                $cotizacion['Encabezado']['MontoExento'],
                isset($cotizacion['Encabezado']['MontoNoFacturable']) ? $cotizacion['Encabezado']['MontoNoFacturable'] : 0,
                $cotizacion['Encabezado']['Descuento'],
                $cotizacion['Encabezado']['TipoDocumento'],
                $cotizacion['Encabezado']['Folio'],
                $cotizacion['Encabezado']['AreaNegocio'],
                $cotizacion['Encabezado']['CondicionPago'],
                $cotizacion['Encabezado']['Vendedor'],
                isset($cotizacion['Encabezado']['Observacion']) ? $cotizacion['Encabezado']['Observacion'] : '',
                isset($cotizacion['Encabezado']['Direccion']) ? $cotizacion['Encabezado']['Direccion'] : NULL,
                $cotizacion['Detalle'],
                $cotizacion['Adicional']
            );

            $respuestas[$item] = $cotiza->ingresarCotizacion();

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuestas[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuestas);
    }


    public function actualizaEstadoCotizacion(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $this->validateJson($request, [
           'tipo' => 'required',
           'folio' => 'required',
           'estado' => 'required',
           'descripcion' => 'required'
           //'no_adj' => 'required',
           //'nula' => 'required'
        ]);

        $estado = $datos['estado'];
        $descripcion = $datos['descripcion'];
        $folio = $datos['folio'];
        $tipo = $datos['tipo'];
        $id_na = (!empty($datos['no_adj'])) ? $datos['no_adj'] : '' ;
        $id_nula = (!empty($datos['nula'])) ? $datos['nula'] : '' ;

        $lista_estados = array(3,4,7);

        if (in_array($estado, $lista_estados)) {
            $respuesta[] = ['mensaje' => 'Estado no permitido para actualizar.'];
            return response()->json($respuesta);
        }

        if ($id_na != '') {
            $tabla = 'cot_razon_no_adju';
            $id = $id_na;
        }

        if ($id_nula != '') {
            $tabla = 'cot_razon_nula';
            $id = $id_nula;
        }

        //validar datos necesarios para actualizar estado


        /*if ($estado == 3) {

            $respuesta[] = ['mensaje' => 'No puede Realizar cambios debido a que EL Rut '.$datos['rut_cliente'].' NO es cliente'];
            return response()->json($respuesta);
        }*/


        $libro_ventas = DB::table('libro_ventas')
       ->where('rut', $usuario->rut_empresa)
       ->where('typo_doc', $tipo)
       ->where('n_doc', $folio)
       ->get();

        //cambiar estado cotizacion
        if ($id_na != '' or $id_nula != '') {
            $result = DB::table($tabla)
            ->where('ID', $id)
            ->get();
            $motivo = $result[0]->NOMBRE;

            if ($id_na != '') {
                $id_es = $id_na;
            }
            if ($id_nula != '') {
                $id_es = $id_nula;
            }

            DB::table('adicional_libro_ventas')
            ->where('RUT_EMPRESA', $usuario->rut_empresa)
            ->where('typo_doc', $tipo)
            ->where('n_doc', $folio)
            ->update([
                'ID_MOTIVO_NA' => $id_es,
                'MOTIVO_NA' => $motivo,
            ]);

        }


        DB::table('libro_ventas')
       ->where('rut', $usuario->rut_empresa)
       ->where('typo_doc', $tipo)
       ->where('n_doc', $folio)
       ->update([
           'ID_ENVIO' => $estado,
       ]);


       DB::table('adicional_libro_ventas')
       ->where('RUT_EMPRESA', $usuario->rut_empresa)
       ->where('typo_doc', $tipo)
       ->where('n_doc', $folio)
       ->update([
           'ESTADO_COT' => $estado,
           'OBS_COT' => $descripcion,
       ]);

       $hora = date('H:i:s');
       $fech = date('Y-m-d');

       DB::table('historico_cotizacion')
           ->insert([
               'RUT_EMPRESA' => $usuario->rut_empresa,
               'RUT_CLIENTE' => $libro_ventas[0]->rut_c,
               'TIPO_DOC' => $tipo,
               'N_DOC' => $folio,
               'ESTADO' => $estado,
               'DESCRIPCION' => $descripcion,
               'FECHA' => $fech,
               'HORA' => $hora,
               'USER' => $usuario->rut_usuario
           ]);

        $respuesta[] =  [
            'mensaje' => 'Estado actualizado de cotizacion folio ',
            'folio' => $folio
        ];
        return response()->json($respuesta);
    }



    public function ingresarNotaVenta(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        /*Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );*/

        foreach($datos as $notaVenta) {
            $respuesta = [];
            try{
                $this->validateArray($request, $notaVenta, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.MontoNeto' => 'required|numeric|min:0',
                    'Encabezado.MontoExento' => 'required|numeric|min:0',
                    'Encabezado.MontoNoFacturable' => 'sometimes|numeric|min:0',
                    'Encabezado.Descuento' => 'required|numeric|min:0',
                    'Encabezado.TipoDocumento' => 'required|integer|in:'.NotaVenta::NOTA_VENTA_AFECTA,
                    'Encabezado.Folio' => 'required|numeric|min:0',
                    'Encabezado.AreaNegocio' => 'required|numeric',
                    'Encabezado.CondicionPago' => 'required|integer',   //Forma de Pago
                    'Encabezado.Vendedor' => 'required|rut',    //Vendedor
                    'Encabezado.Observacion' => 'sometimes|required|max:255',
                    'Encabezado.Direccion' => 'sometimes|required|integer',

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:0',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',

                    'Adicional.Treinta' => 'sometimes|required|numeric|min:0', //donacion

                ]);
            }catch(Exception $e) {
                $respuestas[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            $nota_de_venta = new NotaVenta(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $notaVenta['Encabezado']['Receptor'],
                $notaVenta['Encabezado']['MontoNeto'],
                $notaVenta['Encabezado']['MontoExento'],
                isset($notaVenta['Encabezado']['MontoNoFacturable']) ? $notaVenta['Encabezado']['MontoNoFacturable'] : 0,
                $notaVenta['Encabezado']['Descuento'],
                $notaVenta['Encabezado']['TipoDocumento'],
                $notaVenta['Encabezado']['Folio'],
                $notaVenta['Encabezado']['AreaNegocio'],
                $notaVenta['Encabezado']['CondicionPago'],
                $notaVenta['Encabezado']['Observacion'],
                isset($notaVenta['Encabezado']['Direccion']) ? $notaVenta['Encabezado']['Direccion'] : NULL,
                $notaVenta['Detalle'],
                $notaVenta['Adicional']
            );

            $respuestas[$item] = $nota_de_venta->ingresarNotaVenta();

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuestas[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuestas);
    }

    public function ingresarOrdenCompra(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        foreach($datos as $ordenCompra) {
            $respuesta = [];
            try{
                $this->validateArray($request, $ordenCompra, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.MontoNeto' => 'required|numeric|min:0',
                    'Encabezado.MontoExento' => 'required|numeric|min:0',
                    'Encabezado.MontoNoFacturable' => 'sometimes|numeric|min:0',
                    'Encabezado.Descuento' => 'required|numeric|min:0',
                    'Encabezado.TipoDocumento' => 'required|integer|in:'.ORDENCOMPRA::ORDENCOMPRA,
                    'Encabezado.Folio' => 'required|numeric|min:0',
                    'Encabezado.CondicionPago' => 'required|integer',   //Forma de Pago
                    'Encabezado.ClasificacionCompra' => 'required|numeric',
                    'Encabezado.CentroCosto' => 'required|numeric',
                    'Encabezado.SolicitadoPor' => 'required|rut',
                    
                    'Encabezado.Observacion' => 'sometimes|required|max:255',

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:0',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',


                ]);
            }catch(Exception $e) {
                $respuestas[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            $orden_de_compra = new OrdenCompra(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $ordenCompra['Encabezado']['Receptor'],
                $ordenCompra['Encabezado']['MontoNeto'],
                $ordenCompra['Encabezado']['MontoExento'],
                $ordenCompra['Encabezado']['Descuento'],
                $ordenCompra['Encabezado']['TipoDocumento'],
                $ordenCompra['Encabezado']['Folio'],
                $ordenCompra['Encabezado']['CondicionPago'],
                $ordenCompra['Encabezado']['ClasificacionCompra'],
                $ordenCompra['Encabezado']['CentroCosto'],
                $ordenCompra['Encabezado']['SolicitadoPor'],
                $ordenCompra['Encabezado']['Observacion'],
                $ordenCompra['Detalle'],
                $ordenCompra['Adicional']
            );

            $respuestas[$item] = $orden_de_compra->ingresarOrdenCompra();

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuestas[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuestas);
    }

    public function ingresarGuiaDespacho(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        /*Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );*/


        foreach($datos as $guiaDespacho) {
            $respuesta = [];
            try{

                $this->validateArray($request, $guiaDespacho, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.IndTraslado' => 'required|integer|in:1,2,3,4,5,6,7,8',   //1 ope. conts. venta
                    'Encabezado.TipoDespacho' => 'required|integer|in:1,2,3,4',
                    'Encabezado.MontoNeto' => 'required|numeric|min:0',
                    'Encabezado.MontoExento' => 'required|numeric|min:0',
                    'Encabezado.Descuento' => 'required|numeric|min:0',
                    'Encabezado.CondicionPago' => 'required|numeric',
                    'Encabezado.AreaNegocio' => 'required|numeric',
                    'Encabezado.Vendedor' => 'required|max:255',

                    //'Encabezado.OrdenCompra' => 'sometimes|required|max:255',
                    //'Encabezado.BodegaDefault' => 'sometimes|required|max:255',
                    'Encabezado.Observacion' => 'sometimes|required|max:255',
                    'Encabezado.Direccion' => 'required|integer',

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:0',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',
                    'Detalle.*.Bodega' => 'required|integer',

                    'Adicional.Uno' => 'required|integer', //Forma de Pago
                    'Adicional.Dos' => 'required|rut',//Vendedor
                    'Adicional.Treinta' => 'sometimes|required|numeric|min:0', //donacion
                ]);

            }catch(Exception $e) {
                $respuestas[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            $guiaDespachoElectronica = new GuiaDespacho(
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $guiaDespacho['Encabezado']['Receptor'],
                $guiaDespacho['Encabezado']['IndTraslado'],
                $guiaDespacho['Encabezado']['TipoDespacho'],
                $guiaDespacho['Encabezado']['MontoNeto'],
                $guiaDespacho['Encabezado']['MontoExento'],
                $guiaDespacho['Encabezado']['Descuento'],
                isset($guiaDespacho['Encabezado']['Folio']) ? $guiaDespacho['Encabezado']['Folio'] : '',
                $guiaDespacho['Encabezado']['CondicionPago'],
                $guiaDespacho['Encabezado']['AreaNegocio'],
                $guiaDespacho['Encabezado']['Vendedor'],
                isset($guiaDespacho['Encabezado']['OrdenCompra']) ? $guiaDespacho['Encabezado']['OrdenCompra']: '',
                $guiaDespacho['Encabezado']['Observacion'],
                isset($guiaDespacho['Encabezado']['Direccion']) ? $guiaDespacho['Encabezado']['Direccion'] : NULL,
                $guiaDespacho['Detalle'],
                $guiaDespacho['Adicional']
            );

            $respuestas[$item] = $guiaDespachoElectronica->ingresarGuiaDespacho();

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuestas[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuestas);
    }

    public function ingresarFactura(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        /*Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );*/

        foreach($datos as $factura) {
            $respuesta = [];
            try{
                $this->validateArray($request, $factura, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.MontoNeto' => 'required|numeric|min:0',
                    'Encabezado.MontoExento' => 'required|numeric|min:0',
                    'Encabezado.Descuento' => 'required|numeric|min:0',
                    'Encabezado.TipoDocumento' => 'required|integer|in:'.Factura::FACTURA_AFECTA.','.Factura::FACTURA_EXENTA,
                    'Encabezado.AreaNegocio' => 'required|numeric',
                    'Encabezado.Observacion' => 'sometimes|required|max:255',
                    'Encabezado.Direccion' => 'sometimes|required|max:255',

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:0',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',
                    'Detalle.*.Bodega' => 'required|integer',

                    'Referencia' => 'sometimes|required|array',
                    'Referencia.*.Tipo' => 'required|integer',
                    'Referencia.*.Folio' => 'required|max:255',
                    'Referencia.*.Fecha' => 'required|max:255',
                    'Referencia.*.Razon' => 'required|max:80',

                    /*$xml .="<Referencia>\n";
                    $xml .="<NroLinRef>$n</NroLinRef>\n";
                    $xml .="<TpoDocRef>$tiporef</TpoDocRef>\n";
                    $xml .="<FolioRef>$folioref</FolioRef>\n";
                    $xml .="<FchRef>$fecharef</FchRef>\n";
                    $xml .="<RazonRef>$razon_ref</RazonRef>\n";
                    $xml .="<RazonRef>$razonref</RazonRef>\n";
                    $xml .="</Referencia>\n";*/



                    'Adicional.Uno' => 'required|integer', //Forma de Pago
                    'Adicional.Dos' => 'required|rut',//Vendedor
                    'Adicional.Treinta' => 'sometimes|required|numeric|min:0', //donacion
                ]);
            }catch(Exception $e) {
                $respuestas[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            $facturacion = new Factura(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $factura['Encabezado']['Receptor'],
                $factura['Encabezado']['MontoNeto'],
                $factura['Encabezado']['MontoExento'],
                $factura['Encabezado']['Descuento'],
                $factura['Encabezado']['TipoDocumento'],
                $factura['Encabezado']['AreaNegocio'],
                isset($factura['Encabezado']['Observacion']) ? $factura['Encabezado']['Observacion']: '',
                isset($factura['Encabezado']['Direccion']) ? $factura['Encabezado']['Direccion'] : NULL,
                $factura['Detalle'],
                isset($factura['Referencia']) ? $factura['Referencia'] : [],
                $factura['Adicional']
            );

            $respuestas[$item] = $facturacion->ingresarFactura();

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuestas[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuestas);
    }

    public function ingresarNotaCredito(Request $request){
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);

        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        /*Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );*/

        //ingresando o generando nota de credito
        foreach($datos as $notaCredito) {
            $respuesta = [];
            try{
                $this->validateArray($request, $notaCredito, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.MontoNeto' => 'required|numeric|min:0',
                    'Encabezado.MontoExento' => 'sometimes|required|numeric|min:0',
                    'Encabezado.Descuento' => 'required|numeric|min:0',
                    'Encabezado.Folio' => 'required|numeric|min:0',
                    'Encabezado.AreaNegocio' => 'required|numeric',
                    'Encabezado.CondicionPago' => 'required|integer',   //Forma de Pago
                    'Encabezado.Vendedor' => 'required|rut',    //Vendedor
                    'Encabezado.Observacion' => 'sometimes|required|max:255',
                    'Encabezado.Direccion' => 'sometimes|required',

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'sometimes|required',
                    'Detalle.*.Detalle' => 'sometimes|required',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:0',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',

                    'Referencia' => 'required|array',
                    'Referencia.*.Numero' => 'required|numeric|min:0',
                    'Referencia.*.Tipo' => 'required|numeric|min:0',
                    'Referencia.*.Folio' => 'required|numeric|min:0',
                    'Referencia.*.Fecha' => 'required|date',
                    'Referencia.*.CodigoNC' => 'required|numeric|min:0',
                    'Referencia.*.Razon' => 'required',
                ]);
            }catch(Exception $e) {
                $respuestas[$item] = (array) $e->getResponse()->getData();
                continue;
            }


            $notas_de_credito = new NotaCredito(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $notaCredito['Encabezado']['Receptor'],
                Date('Y-m-d'),
                $notaCredito['Encabezado']['Folio'],
                $notaCredito['Encabezado']['MontoNeto'],
                isset($notaCredito['Encabezado']['MontoExento']) ? $notaCredito['Encabezado']['MontoExento'] : '0',
                $notaCredito['Encabezado']['Descuento'],
                $notaCredito['Encabezado']['AreaNegocio'],
                $notaCredito['Encabezado']['CondicionPago'],
                $notaCredito['Encabezado']['Vendedor'],
                isset($notaCredito['Encabezado']['Observacion']) ? $notaCredito['Encabezado']['Observacion']:'',

                $notaCredito['Detalle'],
                $notaCredito['Referencia'],
                $notaCredito['Adicional']
            );
            $respuestas[$item] = $notas_de_credito->ingresarNotaCredito();


            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuestas[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuestas);
    }

    public function ingresarBoleta(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $respuestas = [];

        foreach($datos as $item => $boleta) {
            $respuesta = [];
            try{

                $this->validateArray($request, $boleta, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.MontoNeto' => 'required|numeric|min:0',
                    'Encabezado.Descuento' => 'required|numeric|min:0',
                    //'Encabezado.MontoNoFacturable' => 'sometimes|numeric|min:0',
                    'Encabezado.TipoDocumento' => 'required|integer|in:'.self::BOLETA_AFECTA.','.self::BOLETA_EXENTA,
                    'Encabezado.AreaNegocio' => 'required|numeric',
                    'Encabezado.Observacion' => 'sometimes|required|max:255',

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:0',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',
                    'Detalle.*.Bodega' => 'required|integer',

                    'Adicional.Uno' => 'required|integer', //Forma de Pago
                    'Adicional.Dos' => 'required|rut',//Vendedor
                    'Adicional.Nueve' => 'sometimes|required',  //forma de pago
                    'Adicional.Diez' => 'sometimes|required',   //numero de pedido
                    'Adicional.Treinta' => 'sometimes|required|numeric|min:0', //donacion
                ]);
            }catch(Exception $e){

                $respuestas[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            //instanciar boleta
            $emision = new Boleta(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $item,
                $boleta['Encabezado']['Receptor'],
                $boleta['Encabezado']['MontoNeto'],
                0,
                $boleta['Encabezado']['Descuento'],
                isset($boleta['Encabezado']['MontoNoFacturable']) ? $boleta['Encabezado']['MontoNoFacturable']: 0,
                $boleta['Encabezado']['TipoDocumento'],
                $boleta['Encabezado']['AreaNegocio'],
                isset($boleta['Encabezado']['Observacion']) ? $boleta['Encabezado']['Observacion']:'',
                isset($boleta['Encabezado']['Direccion']) ? $boleta['Encabezado']['Direccion'] : NULL,
                $boleta['Detalle'],
                $boleta['Adicional']
            );

            $respuestas[$item] = $emision->ingresarBoleta();
        }

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json($respuestas);
    }

    public function ingresarBoleta2(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        /*Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );*/

        foreach($datos as $documento) {
            $respuesta = [];
            try{
                $this->validateArray($request, $documento, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.TipoDocumento' => 'required|integer|in:'.self::BOLETA_AFECTA.','.self::BOLETA_EXENTA,
                    'Encabezado.AreaNegocio' => 'required|numeric',
                    'Encabezado.Observacion' => 'sometimes|required|max:255',
                    'Encabezado.Direccion' => 'sometimes|required|max:255',

                    'Totales' => 'required|array',
                    'Totales.*.MontoNeto' => 'required|numeric|min:100',
                    'Totales.*.MontoExento' => 'sometimes|numeric|min:0',
                    'Totales.*.Descuento' => 'required|numeric|min:0',
                    'Totales.*.MontoNoFacturable' => 'sometimes|numeric|min:0',
                    'Totales.*.MontoIva' => 'required|numeric|min:19',
                    'Totales.*.MontoTotal' => 'required|numeric|min:119',

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:0',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',
                    'Detalle.*.Bodega' => 'required|integer',

                    'Adicional.Uno' => 'required|integer', //Forma de Pago
                    'Adicional.Dos' => 'required|rut',//Vendedor
                    'Adicional.Treinta' => 'sometimes|required|numeric|min:0', //donacion
                ]);
            }catch(Exception $e) {
                $respuestas[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            $emision = new Boleta2(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $documento['Encabezado']['Receptor'],
                $documento['Encabezado']['TipoDocumento'],
                $documento['Encabezado']['AreaNegocio'],
                $documento['Encabezado']['Observacion'],
                isset($documento['Encabezado']['Direccion']) ? $documento['Encabezado']['Direccion'] : NULL,
                $documento['Totales'],
                $documento['Detalle'],
                $documento['Adicional']
            );

            $respuestas[$item] = $emision->ingresarBoleta();

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuestas[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuestas);
    }

    public function ingresarBoletaNew(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        /*Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );*/

        foreach($datos as $datosBoleta) {

            $respuesta = [];
            try{
                $this->validateArray($request, $datosBoleta, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.MontoNeto' => 'required|numeric|min:0',
                    'Encabezado.Descuento' => 'required|numeric|min:0',
                    'Encabezado.TipoDocumento' => 'required|integer|in:'.self::BOLETA_AFECTA.','.self::BOLETA_EXENTA,
                    'Encabezado.AreaNegocio' => 'required|numeric',
                    'Encabezado.Observacion' => 'sometimes|required|max:255',

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:0',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',
                    'Detalle.*.Bodega' => 'required|integer',

                    'Adicional.Uno' => 'required|integer', //Forma de Pago
                    'Adicional.Dos' => 'required|rut',//Vendedor
                    'Adicional.Nueve' => 'sometimes|required',  //forma de pago
                    'Adicional.Diez' => 'sometimes|required',   //numero de pedido
                    'Adicional.Treinta' => 'sometimes|required|numeric|min:0', //donacion
                ]);

            }catch(Exception $e) {
                $respuestas[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            $boleta = new Boleta(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $datosBoleta['Encabezado']['Receptor'],
                $datosBoleta['Encabezado']['MontoNeto'],
                isset($datosBoleta['Encabezado']['MontoExento']) ? $datosBoleta['Encabezado']['MontoExento'] : 0,
                $datosBoleta['Encabezado']['Descuento'],
                $datosBoleta['Encabezado']['TipoDocumento'],
                $datosBoleta['Encabezado']['AreaNegocio'],
                isset($datosBoleta['Encabezado']['Observacion']) ? $datosBoleta['Encabezado']['Observacion'] : "",
                isset($datosBoleta['Encabezado']['Direccion']) ? $datosBoleta['Encabezado']['Direccion'] : NULL,
                $datosBoleta['Detalle'],
                $datosBoleta['Adicional']
            );

            $respuestas[$item] = $boleta->ingresarBoleta();

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuestas[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuestas);
    }

    public function ingresarWoopy(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $respuestas = [];

        /*Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );*/

        $item = 0;
        foreach($datos as $doc) {
            $respuesta = [];
            try{

                $this->validateArray($request, $doc, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.Razon' => 'required|max:100',
                    'Encabezado.Giro' => 'sometimes|max:100',
                    'Encabezado.Telefono' => 'required',
                    'Encabezado.MontoNeto' => 'required|numeric|min:0',
                    'Encabezado.MontoNoFacturable' => 'sometimes|numeric|min:0',
                    'Encabezado.MontoIva' => 'required|numeric|min:0',
                    'Encabezado.MontoTotal' => 'required|numeric|min:0',
                    'Encabezado.Descuento' => 'required|numeric|min:0',
                    'Encabezado.TipoDocumento' => 'required|integer|in:'.self::BOLETA_AFECTA.','.self::BOLETA_EXENTA,
                    //'Encabezado.AreaNegocio' => 'required|numeric',
                    'Encabezado.Observacion' => 'sometimes|required|max:255',
                    'Encabezado.Direccion' => 'required',
                    'Encabezado.Comuna' => 'required|max:20',
                    'Encabezado.Ciudad' => 'required|max:20',

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required|max:35',
                    //'Detalle.*.Detalle' => 'required|max:80',
                    //'Detalle.*.UnidadMedida' => 'required|min:2|max:3',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:1',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',

                    /*'Referencia' => 'required|array',
                    'Referencia.*.Tipo' => 'required|',
                    'Referencia.*.Folio' => 'required',
                    'Referencia.*.Fecha' => 'required|date',
                    'Referencia.*.Razon' => 'required|max:80',*/

                    //'Adicional.Uno' => 'required|integer', //Forma de Pago
                    //'Adicional.Dos' => 'required|rut',//Vendedor
                    'Adicional.Treinta' => 'sometimes|required|numeric|min:0', //donacion
                ]);
            }catch(Exception $e) {
                $respuesta[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            $documento = new Woopy(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $doc['Encabezado']['Receptor'],
                $doc['Encabezado']['Razon'],
                isset($doc['Encabezado']['Giro']) ? $doc['Encabezado']['Giro']: '',
                $doc['Encabezado']['Telefono'],
                $doc['Encabezado']['MontoNeto'],
                isset($doc['Encabezado']['MontoExento']) ? $doc['Encabezado']['MontoExento']: 0,
                $doc['Encabezado']['MontoNoFacturable'],
                $doc['Encabezado']['MontoIva'],
                $doc['Encabezado']['MontoTotal'],
                $doc['Encabezado']['Descuento'],
                $doc['Encabezado']['TipoDocumento'],
                //$doc['Encabezado']['AreaNegocio'],
                $doc['Encabezado']['Observacion'],
                $doc['Encabezado']['Direccion'],
                $doc['Encabezado']['Comuna'],
                $doc['Encabezado']['Ciudad'],
                $doc['Detalle'],
                //$doc['Referencia'],
                $doc['Adicional']
            );


            $respuesta[$item] = $documento->ingresarWoopy();

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuesta[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuesta);

    }

    public function ingresarEcomerce(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $respuestas = [];

        $item = 0;
        foreach($datos as $doc) {
            $respuesta = [];
            try{

                $this->validateArray($request, $doc, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.Razon' => 'required|max:100',
                    'Encabezado.Giro' => 'sometimes|max:100',
                    'Encabezado.Telefono' => 'required',
                    'Encabezado.MontoNeto' => 'required|numeric|min:0',
                    'Encabezado.MontoNoFacturable' => 'sometimes|numeric|min:0',
                    //'Encabezado.MontoIva' => 'required|numeric|min:0',
                    //'Encabezado.MontoTotal' => 'required|numeric|min:0',
                    'Encabezado.Descuento' => 'required|numeric|min:0',
                    'Encabezado.NumeroPedido' => 'numeric|min:0',
                    'Encabezado.TipoDocumento' => 'required|integer|in:'.self::BOLETA_AFECTA.','.self::BOLETA_EXENTA.','.self::FACTURA_AFECTA.','.self::VALE_COMPROBANTE,
                    //'Encabezado.AreaNegocio' => 'required|numeric',
                    'Encabezado.Observacion' => 'sometimes|required|max:255',
                    'Encabezado.Direccion' => 'required',
                    'Encabezado.Comuna' => 'required|max:20',
                    'Encabezado.Ciudad' => 'required|max:20',

                    'Encabezado.DirDespachoDireccion' => 'sometimes|required||max:80',
                    'Encabezado.DirDespachoComuna' => 'sometimes|required|max:80',
                    'Encabezado.DirDespachoCiudad' => 'sometimes|required|max:80',

                    'Encabezado.OrdenTransporte' => 'sometimes|required|max:20',

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required|max:35',
                    'Detalle.*.Detalle' => 'required|max:80',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:1',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',

                    /*'Referencia' => 'required|array',
                    'Referencia.*.Tipo' => 'required|',
                    'Referencia.*.Folio' => 'required',
                    'Referencia.*.Fecha' => 'required|date',
                    'Referencia.*.Razon' => 'required|max:80',*/

                    //'Adicional.Uno' => 'required|integer', //Forma de Pago
                    //'Adicional.Dos' => 'required|rut',//Vendedor
                    'Adicional.Treinta' => 'sometimes|required|numeric|min:0', //donacion
                ]);
            }catch(Exception $e) {
                $respuesta[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            $documento = new Ecomerce(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $doc['Encabezado']['Receptor'],
                $doc['Encabezado']['Razon'],
                isset($doc['Encabezado']['Giro']) ? $doc['Encabezado']['Giro']: '',
                $doc['Encabezado']['Telefono'],
                $doc['Encabezado']['MontoNeto'],
                isset($doc['Encabezado']['MontoNoFacturable']) ? $doc['Encabezado']['MontoNoFacturable'] : 0,
                //$doc['Encabezado']['MontoIva'],
                //$doc['Encabezado']['MontoTotal'],
                $doc['Encabezado']['Descuento'],
                isset($doc['Encabezado']['NumeroPedido']) ? $doc['Encabezado']['NumeroPedido'] : 0,
                $doc['Encabezado']['TipoDocumento'],
                //$doc['Encabezado']['AreaNegocio'],
                $doc['Encabezado']['Observacion'],
                $doc['Encabezado']['Direccion'],
                $doc['Encabezado']['Comuna'],
                $doc['Encabezado']['Ciudad'],

                isset($doc['Encabezado']['DirDespachoDireccion']) ? $doc['Encabezado']['DirDespachoDireccion'] : "",
                isset($doc['Encabezado']['DirDespachoComuna']) ? $doc['Encabezado']['DirDespachoComuna'] : "",
                isset($doc['Encabezado']['DirDespachoCiudad']) ? $doc['Encabezado']['DirDespachoCiudad'] : "",

                isset($doc['Encabezado']['OrdenTransporte']) ? $doc['Encabezado']['OrdenTransporte'] : 0,

                $doc['Detalle'],
                //$doc['Referencia'],
                $doc['Adicional']
            );


            $respuesta[$item] = $documento->ingresarWoopy();

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuesta[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuesta);

    }


    public function ingresarPedido(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $respuestas = [];

        /*Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );*/

        $item = 0;
        foreach($datos as $doc) {
            $respuesta = [];
            try{

                $this->validateArray($request, $doc, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Id_pedido' => 'required|numeric|min:0',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.Razon' => 'required|max:100',
                    'Encabezado.MontoNeto' => 'required|numeric|min:0',
                    'Encabezado.MontoIva' => 'required|numeric|min:0',
                    'Encabezado.MontoTotal' => 'required|numeric|min:0',
                    'Encabezado.Descuento' => 'required|numeric|min:0',
                    'Encabezado.Observacion' => 'sometimes|required|max:255',

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required|max:35',
                    'Detalle.*.Detalle' => 'required|max:80',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:1',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',

                ]);
            }catch(Exception $e) {
                $respuesta[$item] = (array) $e->getResponse()->getData();
                continue;
            }

            $documento = new Pedido(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $doc['Encabezado']['Id_pedido'],
                $doc['Encabezado']['Receptor'],
                $doc['Encabezado']['Razon'],
                $doc['Encabezado']['MontoNeto'],
                $doc['Encabezado']['MontoIva'],
                $doc['Encabezado']['MontoTotal'],
                $doc['Encabezado']['Descuento'],
                $doc['Encabezado']['Observacion'],
                $doc['Detalle']
            );


            $respuesta[$item] = $documento->ingresarPedido();

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuesta[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuesta);

    }



    public function ingresarPedidoJumpseller(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $respuestas = [];

        /*Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );*/

        //dd($datos);


        // DATOS DEL CLIENTE
        $nombre = ucwords(strtolower(trim($datos['order']['shipping_address']['name']).' '.trim($datos['order']['shipping_address']['surname'])));
        $email  = trim(strtolower($datos['order']['customer']['email']));
        $fono   = trim($datos['order']['customer']['phone']);

        $rut    = $this->limpiaRut($datos['order']['billing_address']['taxid']);
        $direccion = ucfirst(trim($datos['order']['shipping_address']['address']));
        $comuna = ucwords(trim($datos['order']['shipping_address']['city']));
        $pais = ucwords(trim($datos['order']['shipping_address']['country']));
        $mensaje = ucfirst(trim($datos['order']['additional_information']));
        if(empty($mensaje)) {
            $mensaje = 'Compra realizada';
        }

        //falta validar cliente, si no existe crearlo



        // LISTAR PRODUCTOS DE LA COMPRA
        $productos = array();
        foreach($datos['order']['products'] as $p) {
            $productos[] = array(
                'Codigo'    => $p['sku'],
                //buscar detalle de productos en bd
                'Detalle'    => $p['sku'],
                'Cantidad'  => $p['qty'],
                'Descuento' => round($p['discount']),
                'Precio'    => round($p['price']),
                'Afecto'    => true,
                'Bodega'    => '927'
            );
        }

        // ELEGIR MÉTODO DE PAGO
        $metodo_pago = $datos['order']['payment_method_name'];
        if($metodo_pago == 'Webpay Plus Webservices') {
            // WEBPAY
            $pago_id = '5080';
        } elseif($metodo_pago == 'Transferencia bancaria') {
            $pago_id = '5081';
            // TRANSFERENCIA BANCARIA
        } else {
            // CONTADO
            $pago_id = '3032';
        }

        //dd($datos);
        $totales['neto'] = round($datos['order']['total']);
        $totales['Descuento'] = round($datos['order']['discount']);
        $totales['MontoIva'] = round($totales['neto'] * 0.19);
        $totales['MontoTotal'] = round(
            $totales['neto'] + $totales['MontoIva'] - $totales['Descuento']
        );



        // DATOS DE LA COMPRA
        $datos_compra = array(
                            0 => array(
                                'Encabezado' => array(
                                    'Receptor' => $rut,
                                    'Razon' => $nombre,
                                    'Id_pedido' => $datos['order']['id'],
                                    'MontoNeto' => $totales['neto'],
                                    'Descuento' => $totales['Descuento'],
                                    'MontoIva' => $totales['MontoIva'],
                                    'MontoTotal' => $totales['MontoTotal'],
                                    'TipoDocumento' => '39',
                                    'AreaNegocio' => '4354',
                                    'Observacion' => $mensaje,
                                ),
                                'Detalle' => $productos,
                                'Adicional' => array(
                                    'Uno' => $pago_id,
                                    'Dos' => $rut,
                                )
                            )
                        );

        //dd($datos);

        $item = 0;
        foreach($datos_compra as $doc) {
            $respuesta = [];
            try{

                $this->validateArray($request, $doc, [
                    'Encabezado' => 'required|array',
                    'Encabezado.Id_pedido' => 'required|numeric|min:0',
                    'Encabezado.Receptor' => 'required|rut',
                    'Encabezado.Razon' => 'required|max:100',
                    'Encabezado.MontoNeto' => 'required|numeric|min:0',
                    'Encabezado.MontoIva' => 'required|numeric|min:0',
                    'Encabezado.MontoTotal' => 'required|numeric|min:0',
                    'Encabezado.Descuento' => 'required|numeric|min:0',
                    'Encabezado.Observacion' => 'sometimes|required|max:255',

                    'Detalle' => 'required|array',
                    'Detalle.*.Codigo' => 'required|max:35',
                    'Detalle.*.Detalle' => 'required|max:80',
                    'Detalle.*.Precio' => 'sometimes|required|numeric|min:1',
                    'Detalle.*.Cantidad' => 'required|integer|min:1',
                    'Detalle.*.Descuento' => 'required|numeric|min:0',
                    'Detalle.*.Afecto' => 'required|boolean',

                ]);
            }catch(Exception $e) {
                $respuesta[$item] = (array) $e->getResponse()->getData();
                //continue;
            }


            $documento = new Pedido(
                $usuario->id_empresa,
                $usuario->rut_empresa,
                $usuario->rut_usuario,
                $doc['Encabezado']['Id_pedido'],
                $doc['Encabezado']['Receptor'],
                $doc['Encabezado']['Razon'],
                $doc['Encabezado']['MontoNeto'],
                $doc['Encabezado']['MontoIva'],
                $doc['Encabezado']['MontoTotal'],
                $doc['Encabezado']['Descuento'],
                $doc['Encabezado']['Observacion'],
                $doc['Detalle']
            );


            $respuesta[$item] = $documento->ingresarPedido();

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuesta[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuesta);

    }


    public function ingresarBoletaMasiva(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $respuestas = [];

        /*Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );*/

        $iteracion = 0;
        foreach($datos as $item => $listadoBoleta) {
            $respuestasGeneracion = [];
            foreach ($listadoBoleta as $key => $datosBoleta) {

                $respuesta = [];
                try{

                    $this->validateArray($request, $datosBoleta, [
                        'Encabezado' => 'required|array',
                        'Encabezado.Receptor' => 'required|rut',
                        'Encabezado.MontoNeto' => 'required|numeric|min:0',
                        'Encabezado.MontoExento' => 'sometimes|required|numeric|min:0',
                        'Encabezado.Descuento' => 'required|numeric|min:0',
                        'Encabezado.TipoDocumento' => 'required|integer|in:'.self::BOLETA_AFECTA.','.self::BOLETA_EXENTA,
                        'Encabezado.AreaNegocio' => 'required|numeric',
                        'Encabezado.Observacion' => 'sometimes|required|max:255',

                        'Detalle' => 'required|array',
                        'Detalle.*.Codigo' => 'required',
                        'Detalle.*.Precio' => 'sometimes|required|numeric|min:0',
                        'Detalle.*.Cantidad' => 'required|integer|min:1',
                        'Detalle.*.Descuento' => 'required|numeric|min:0',
                        'Detalle.*.Afecto' => 'required|boolean',
                        'Detalle.*.Bodega' => 'required|integer',

                        'Adicional.Uno' => 'required|integer', //Forma de Pago
                        'Adicional.Dos' => 'required|rut',//Vendedor
                        'Adicional.Treinta' => 'sometimes|required|numeric|min:0', //donacion
                    ]);

                    $boleta = new Boleta(
                        $usuario->id_empresa,
                        $usuario->rut_empresa,
                        $usuario->rut_usuario,
                        $datosBoleta['Encabezado']['Receptor'],
                        $datosBoleta['Encabezado']['MontoNeto'],
                        isset($datosBoleta['Encabezado']['MontoExento']) ? $datosBoleta['Encabezado']['MontoExento'] : 0,
                        $datosBoleta['Encabezado']['Descuento'],
                        $datosBoleta['Encabezado']['TipoDocumento'],
                        $datosBoleta['Encabezado']['AreaNegocio'],
                        isset($datosBoleta['Encabezado']['Observacion']) ? $datosBoleta['Encabezado']['Observacion'] : "",
                        isset($datosBoleta['Encabezado']['Direccion']) ? $datosBoleta['Encabezado']['Direccion'] : NULL,
                        $datosBoleta['Detalle'],
                        $datosBoleta['Adicional']
                    );
                    //dd($boleta->ingresarBoleta());
                    $respuestas[$item] = $boleta->ingresarBoleta();

                    $respuestasGeneracion[$iteracion] = $respuestas;
                    $iteracion++;

                }catch(Exception $e){

                    $respuestas[$item] = (array) $e->getResponse()->getData();
                    continue;
                }
                //print_r($respuestasGeneracion);
            }

            //dd($respuestasGeneracion);

            Logger::log(
                $usuario->rut_empresa,
                $request->path(),
                $request->method(),
                $usuario->rut_usuario,
                $datos,
                $respuestas[$item],
                ENV('AMBIENTE_SII'),
                $request->ip()
            );
        }
        return response()->json($respuestasGeneracion);

    }


    protected function calculaTotalesBoleta($tipoDocumento, $montoNeto, $descuento)
    {
        $montosTotales = [];

        if($tipoDocumento == self::BOLETA_EXENTA) {
            $montosTotales['neto'] = $montoNeto;
            $montosTotales['exento'] = $montoNeto - $descuento;
            $montosTotales['iva'] = 0;
            $montosTotales['total'] = $montosTotales['exento'];
        }
        else if($tipoDocumento == self::BOLETA_AFECTA) {
            $montosTotales['neto'] = $montoNeto;
            $montosTotales['iva'] = ($montoNeto - $descuento) * env('IVA');
            $montosTotales['total'] = ($montoNeto - $descuento) + $montosTotales['iva'];
            $montosTotales['exento'] = 0;
        }

        return $montosTotales;
    }

    protected function formateaNumero($numero)
    {
        return number_format($numero, 0, ',', '');
    }

    protected function obtenFormaPago($id, $rut_emisor)
    {
        return DB::table('cpago')
            ->where('ID_CPAGO', '=', $id)
            ->whereRaw('ID_EMPRESA = \''.$rut_emisor.'\'')
            ->first();
    }

    protected function obtenListaSucursales($rut_emisor)
    {
        return DB::table('sucursales')
            ->select('DIRECCION_SUCURSAL','ID_COMUNA','ID_CIUDAD','NOMBRE_SUCURSAL','mostrar_api')
            ->where('ADICIONAL2_SUCURSAL', '=', 1)
            ->whereRaw('ID_EMPRESA = \''.$rut_emisor.'\'')
            ->get();
    }

    protected function obtenAreaNegocio($id, $rut_emisor)
    {
        return DB::table('areanegocio')
            ->whereRaw('ID_EMPRESA = \''.$rut_emisor.'\'')
            ->where('ID_AREANEGOCIO', '=', $id)
            ->where('ESTADO', '=', 1)
            ->first();
    }

    protected function obtenDatosEmisor($rut_emisor)
    {
        return DB::table('datos_empresa')
            ->whereRaw('rut = \''.$rut_emisor.'\'')
            ->where('ESISTEMA', '=', 1)
            ->first();
    }

    protected function generaXmlDTE($datos, $listadoDetalles)
    {
        $xml_detalle = '';

        $item = 1;
        foreach($listadoDetalles as $detalle) {
            $total_detalle = $detalle['Cantidad'] * $detalle['Precio'];
            $xml_detalle .= '<Detalle>
               <NroLinDet>'.$item.'</NroLinDet>
               <CdgItem>
                  <TpoCodigo />
                  <VlrCodigo>'.$detalle['Codigo'].'</VlrCodigo>
               </CdgItem>
               <NmbItem>'.$detalle['Detalle'].'</NmbItem>
               <QtyItem>'.$detalle['Cantidad'].'</QtyItem>
               <UnmdItem>'.$detalle['UnidadMedida'].'</UnmdItem>
               <PrcItem>'.$detalle['Precio'].'</PrcItem>
               <MontoItem>'. $total_detalle .'</MontoItem>
            </Detalle>'.PHP_EOL;
            $item++;
        }

        $xml = '<DTE version="1.0">
            <Documento ID="F674T33">
               <Encabezado>
                  <IdDoc>
                     <TipoDTE>'.$datos['TipoDTE'].'</TipoDTE>
                     <Folio>'.$datos['Folio'].'</Folio>
                     <FchEmis>'.date('Y-m-d', time()).'</FchEmis>
                     <IndServicio>3</IndServicio>
                  </IdDoc>
                  <Emisor>
                     <RUTEmisor>'.$datos['RutEmisor'].'</RUTEmisor>
                     <RznSoc>'.htmlspecialchars($datos['RznSoc'], ENT_QUOTES).'</RznSoc>
                     <GiroEmis>'.htmlspecialchars($datos['GiroEmis'], ENT_QUOTES).'</GiroEmis>
                     <Telefono>'.$datos['Telefono'].'</Telefono>
                     <Acteco>'.$datos['Acteco'].'</Acteco>
                     <DirOrigen>'.htmlspecialchars($datos['DirOrigen'], ENT_QUOTES).'</DirOrigen>
                     <CmnaOrigen>'.htmlspecialchars($datos['CmnaOrigen'], ENT_QUOTES).'</CmnaOrigen>
                     <CiudadOrigen>'.htmlspecialchars($datos['CiudadOrigen'], ENT_QUOTES).'</CiudadOrigen>
                  </Emisor>
                  <Receptor>
                     <RUTRecep>'.$datos['RUTRecep'].'</RUTRecep>
                     <RznSocRecep>'.htmlspecialchars($datos['RznSocRecep'], ENT_QUOTES).'</RznSocRecep>
                     <DirRecep>'.htmlspecialchars($datos['DirRecep'], ENT_QUOTES).'</DirRecep>
                     <CmnaRecep>'.htmlspecialchars($datos['CmnaRecep'], ENT_QUOTES).'</CmnaRecep>
                     <CiudadRecep>'.htmlspecialchars($datos['CiudadRecep'], ENT_QUOTES).'</CiudadRecep>
                  </Receptor>
                  <Totales>
                     <MntNeto>'.$datos['MntNeto'].'</MntNeto>
                     <MntExento>'.$datos['MntExento'].'</MntExento>
                     <MntIva>'.$datos['MntIva'].'</MntIva>
                     <MntTotal>'.$datos['MntTotal'].'</MntTotal>
                  </Totales>
               </Encabezado>
               '.$xml_detalle.'
            </Documento>
         </DTE>';

         return $xml;
    }

    protected function generaXmlBoletaBasica($datos)
    {
        $xml_detalle = '';

        $item = 1;
        foreach($datos['Detalles'] as $detalle) {
            $xml_detalle .= '<Detalle>
               <NroLinDet>'.$item.'</NroLinDet>
               <CdgItem>
                  <TpoCodigo />
                  <VlrCodigo>'.$detalle['VlrCodigo'].'</VlrCodigo>
               </CdgItem>

               <NmbItem>'.htmlspecialchars($detalle['NmbItem'], ENT_QUOTES).'</NmbItem>
               <QtyItem>'.htmlspecialchars($detalle['QtyItem'], ENT_QUOTES).'</QtyItem>
               <UnmdItem>'.$detalle['UnmdItem'].'</UnmdItem>
               <PrcItem>'.$detalle['PrcItem'].'</PrcItem>
               <MontoItem>'.$detalle['MontoItem'].'</MontoItem>
            </Detalle>'.PHP_EOL;
            $item++;
        }

        $xml_No_facturable = '';
        if(!empty($datos['MontoNF'])){

            $xml_No_facturable .="<MontoNF>".$datos['MontoNF']."</MontoNF>\n";

            $xml_No_facturable .="<TotalPeriodo>".number_format(($datos['MntTotal'] + $datos['MontoNF']),0,',','')."</TotalPeriodo>\n";
        }


        $xml = '<DTE version="1.0">
            <Documento ID="F674T33">
               <Encabezado>
                  <IdDoc>
                     <TipoDTE>'.$datos['TipoDTE'].'</TipoDTE>
                     <Folio>'.$datos['Folio'].'</Folio>
                     <FchEmis>'.date('Y-m-d', time()).'</FchEmis>
                     <IndServicio>3</IndServicio>
                  </IdDoc>
                  <Emisor>
                     <RUTEmisor>'.$datos['RUTEmisor'].'</RUTEmisor>
                  </Emisor>
                  <Receptor>
                     <RUTRecep>'.$datos['RUTRecep'].'</RUTRecep>
                     <RznSocRecep>'.$datos['RznSocRecep'].'</RznSocRecep>
                     <DirRecep>'.$datos['DirRecep'].'</DirRecep>
                     <CmnaRecep>'.$datos['CmnaRecep'].'</CmnaRecep>
                     <CiudadRecep>'.$datos['CiudadRecep'].'</CiudadRecep>
                  </Receptor>
                  <Totales>
                      <MntNeto>'.$datos['MntNeto'].'</MntNeto>
                      <MntExe>'.$datos['MntExento'].'</MntExe>
                      <IVA>'.$datos['MntIva'].'</IVA>
                      <MntTotal>'.$datos['MntTotal'].'</MntTotal>
                      '.$xml_No_facturable.'
                  </Totales>

               </Encabezado>
               '.$xml_detalle.'
            </Documento>
         </DTE>';

         return $xml;
    }
    protected function generaXmlFactura($datos)
    {
        $xml_detalle = '';

        $item = 1;
        foreach($datos['Detalles'] as $detalle) {
            $xml_detalle .= '<Detalle>
               <NroLinDet>'.$item.'</NroLinDet>
               <CdgItem>
                  <TpoCodigo />
                  <VlrCodigo>'.$detalle['VlrCodigo'].'</VlrCodigo>
               </CdgItem>
               <NmbItem>'.$detalle['NmbItem'].'</NmbItem>
               <QtyItem>'.$detalle['QtyItem'].'</QtyItem>
               <UnmdItem>'.$detalle['UnmdItem'].'</UnmdItem>
               <PrcItem>'.$detalle['PrcItem'].'</PrcItem>
               <MontoItem>'.$detalle['MontoItem'].'</MontoItem>
            </Detalle>'.PHP_EOL;
            $item++;
        }
        $xml = '<DTE version="1.0">
            <Documento ID="F674T33">
               <Encabezado>
                  <IdDoc>
                     <TipoDTE>'.$datos['TipoDTE'].'</TipoDTE>
                     <Folio>'.$datos['Folio'].'</Folio>
                     <FchEmis>'.date('Y-m-d', time()).'</FchEmis>
                     <IndServicio>3</IndServicio>
                  </IdDoc>
                  <Emisor>
                     <RUTEmisor>'.$datos['RUTEmisor'].'</RUTEmisor>
                     <RznSoc>'.$datos['RznSoc'].'</RznSoc>
                     <GiroEmis>'.$datos['GiroEmis'].'</GiroEmis>
                     <Telefono>'.$datos['Telefono'].'</Telefono>
                     <Acteco>'.$datos['Acteco'].'</Acteco>
                     <DirOrigen>'.$datos['DirOrigen'].'</DirOrigen>
                     <CmnaOrigen>'.$datos['CmnaOrigen'].'</CmnaOrigen>
                     <CiudadOrigen>'.$datos['CiudadOrigen'].'</CiudadOrigen>
                  </Emisor>
                  <Receptor>
                     <RUTRecep>'.$datos['RUTRecep'].'</RUTRecep>
                     <RznSocRecep>'.$datos['RznSocRecep'].'</RznSocRecep>
                     <DirRecep>'.$datos['DirRecep'].'</DirRecep>
                     <CmnaRecep>'.$datos['CmnaRecep'].'</CmnaRecep>
                     <CiudadRecep>'.$datos['CiudadRecep'].'</CiudadRecep>
                  </Receptor>
                  <Totales>
                     <MntNeto>'.$datos['MntNeto'].'</MntNeto>
                     <MntExe>'.$datos['MntExe'].'</MntExe>
                     <TasaIVA>'.$datos['TasaIVA'].'</TasaIVA>
                     <IVA>'.$datos['IVA'].'</IVA>
                     <MntTotal>'.$datos['MntTotal'].'</MntTotal>
                  </Totales>
               </Encabezado>
               '.$xml_detalle.'
            </Documento>
         </DTE>';

         return $xml;
    }

    protected function generaXmlAdicionales($datos)
    {
        $xml = '<Adicional>
    	       <Uno>'.(isset($datos['Uno']) ? $datos['Uno'] : '').'</Uno>
    	       <Dos>'.(isset($datos['Dos']) ? $datos['Dos'] : '').'</Dos>
               <Tres>'.(isset($datos['Tres']) ? $datos['Tres'] : '').'</Tres>
               <Cuatro>'.(isset($datos['Cuatro']) ? $datos['Cuatro'] : '').'</Cuatro>
               <Cinco>'.(isset($datos['Cinco']) ? $datos['Cinco'] : '').'</Cinco>
               <Seis>'.(isset($datos['Seis']) ? $datos['Seis'] : '').'</Seis>
               <Siete>'.(isset($datos['Siete']) ? $datos['Siete'] : '').'</Siete>
               <Ocho>'.(isset($datos['Ocho']) ? $datos['Ocho'] : '').'</Ocho>
               <Nueve>'.(isset($datos['Nueve']) ? $datos['Nueve'] : '').'</Nueve>
               <Diez>'.(isset($datos['Diez']) ? $datos['Diez'] : '').'</Diez>
               <Once>'.(isset($datos['Once']) ? $datos['Once'] : '').'</Once>
               <Doce>'.(isset($datos['Doce']) ? $datos['Doce'] : '').'</Doce>
               <Trece>'.(isset($datos['Trece']) ? $datos['Trece'] : '').'</Trece>
               <Catorce>'.(isset($datos['Catorce']) ? $datos['Catorce'] : '').'</Catorce>
               <Quince>'.(isset($datos['Quince']) ? $datos['Quince'] : '').'</Quince>
               <Dieciseis>'.(isset($datos['Dieciseis']) ? $datos['Dieciseis'] : '').'</Dieciseis>
               <Diecisiete>'.(isset($datos['Diecisiete']) ? $datos['Diecisiete'] : '').'</Diecisiete>
               <Dieciocho>'.(isset($datos['Dieciocho']) ? $datos['Dieciocho'] : '').'</Dieciocho>
               <Diecinueve>'.(isset($datos['Diecinueve']) ? $datos['Diecinueve'] : '').'</Diecinueve>
               <Veinte>'.(isset($datos['Veinte']) ? $datos['Veinte'] : '').'</Veinte>
               <Veintiuno>'.(isset($datos['Veintiuno']) ? $datos['Veintiuno'] : '').'</Veintiuno>
               <Veintidos>'.(isset($datos['Veintidos']) ? $datos['Veintidos'] : '').'</Veintidos>
               <Veintitres>'.(isset($datos['Veintitres']) ? $datos['Veintitres'] : '').'</Veintitres>
               <Veinticuatro>'.(isset($datos['Veinticuatro']) ? $datos['Veinticuatro'] : '').'</Veinticuatro>
               <Veinticinco>'.(isset($datos['Veinticinco']) ? $datos['Veinticinco'] : '').'</Veinticinco>
               <Veintiseis>'.(isset($datos['Veintiseis']) ? $datos['Veintiseis'] : '').'</Veintiseis>
               <Veintisiete>'.(isset($datos['Veintisiete']) ? $datos['Veintisiete'] : '').'</Veintisiete>
               <Veintiocho>'.(isset($datos['Veintiocho']) ? $datos['Veintiocho'] : '').'</Veintiocho>
               <Veintinueve>'.(isset($datos['Veintinueve']) ? $datos['Veintinueve'] : '').'</Veintinueve>
               <Treinta>'.(isset($datos['Treinta']) ? $datos['Treinta'] : '').'</Treinta>
               <Treintayuno>'.(isset($datos['Treintayuno']) ? $datos['Treintayuno'] : '').'</Treintayuno>
               <Treintaydos>'.(isset($datos['Treintaydos']) ? $datos['Treintaydos'] : '').'</Treintaydos>
               <Treintaytres>'.(isset($datos['Treintaytres']) ? $datos['Treintaytres'] : '').'</Treintaytres>
               <Treintaycuatro>'.(isset($datos['Treintaycuatro']) ? $datos['Treintaycuatro'] : '').'</Treintaycuatro>
               <Treintaycinco>'.(isset($datos['Treintaycinco']) ? $datos['Treintaycinco'] : '').'</Treintaycinco>
               <Treintayseis>'.(isset($datos['Treintayseis']) ? $datos['Treintayseis'] : '').'</Treintayseis>
               <Treintaysiete>'.(isset($datos['Treintaysiete']) ? $datos['Treintaysiete'] : '').'</Treintaysiete>
               <Treintayocho>'.(isset($datos['Treintayocho']) ? $datos['Treintayocho'] : '').'</Treintayocho>
               <Treintaynueve>'.(isset($datos['Treintaynueve']) ? $datos['Treintaynueve'] : '').'</Treintaynueve>
               <Cuarenta>'.(isset($datos['Cuarenta']) ? $datos['Cuarenta'] : '').'</Cuarenta>
               <Cuarentayuno>'.(isset($datos['Cuarentayuno']) ? $datos['Cuarentayuno'] : '').'</Cuarentayuno>
               <Cuarentaydos>'.(isset($datos['Cuarentaydos']) ? $datos['Cuarentaydos'] : '').'</Cuarentaydos>
               <Cuarentaytres>'.(isset($datos['Cuarentaytres']) ? $datos['Cuarentaytres'] : '').'</Cuarentaytres>
               <Cuarentaycuatro>'.(isset($datos['Cuarentaycuatro']) ? $datos['Cuarentaycuatro'] : '').'</Cuarentaycuatro>
               <Cuarentaycinco>'.(isset($datos['Cuarentaycinco']) ? $datos['Cuarentaycinco'] : '').'</Cuarentaycinco>
               <Cuarentayseis>'.(isset($datos['Cuarentayseis']) ? $datos['Cuarentayseis'] : '').'</Cuarentayseis>
               <Cuarentaysiete>'.(isset($datos['Cuarentaysiete']) ? $datos['Cuarentaysiete'] : '').'</Cuarentaysiete>
               <Cuarentayocho>'.(isset($datos['Cuarentayocho']) ? $datos['Cuarentayocho'] : '').'</Cuarentayocho>
               <Cuarentaynueve>'.(isset($datos['Cuarentaynueve']) ? $datos['Cuarentaynueve'] : '').'</Cuarentaynueve>
               <Cincuenta>'.(isset($datos['Cincuenta']) ? $datos['Cincuenta'] : '').'</Cincuenta>
           </Adicional>';

       return $xml;
    }

    protected function rollback($rut_empresa, $tipo_documento, $folio){
        $ingreso = DB::table('libro_ventas')
            ->whereRaw('rut = \''.$rut_empresa.'\'')
            ->where('typo_doc', '=', $tipo_documento)
            ->where('n_doc', '=', $folio)
            ->delete();

        $ingreso = DB::table('ctacte')
            ->whereRaw('rut_empresa = \''.$rut_empresa.'\'')
            ->where('tipo_doc', '=', $tipo_documento)
            ->where('n_doc_ctacte', '=', $folio)
            ->delete();

        $ingreso = DB::table('desc_global')
            ->whereRaw('ID_EMPRESA = \''.$rut_empresa.'\'')
            ->where('TIPO_DOC', '=', $tipo_documento)
            ->where('FOLIO_DOC', '=', $folio)
            ->delete();

        $ingreso = DB::table('dir_libro_venta')
            ->whereRaw('ID_EMPRESA = \''.$rut_empresa.'\'')
            ->where('TIPO_DIR_LVENTA', '=', $tipo_documento)
            ->where('FOLIO_DIR_LVENTA', '=', $folio)
            ->delete();

        $ingreso = DB::table('adicional_libro_ventas')
            ->whereRaw('RUT_EMPRESA = \''.$rut_empresa.'\'')
            ->where('typo_doc', '=', $tipo_documento)
            ->where('n_doc', '=', $folio)
            ->delete();

        $ingreso = DB::table('detalle_doc2')
            ->whereRaw('RUT_EMPRESA = \''.$rut_empresa.'\'')
            ->where('ID_TIPODOC', '=', $tipo_documento)
            ->where('ID_CORRE_DETALLEDOC', '=', $folio)
            ->delete();

        $ingreso = DB::table('detalle_inv_productos')
            ->whereRaw('RUT_EMPRESA = \''.$rut_empresa.'\'')
            ->where('FOLIO_DOC', '=', $tipo_documento)
            ->where('N_DOC', '=', $folio)
            ->delete();

        $ingreso = DB::table('ref_sistema_ge_especial')
            ->whereRaw('RUT_EMPRESA = \''.$rut_empresa.'\'')
            ->where('ADICIONAL2', '=', $tipo_documento)
            ->where('ADICIONAL1', '=', $folio)
            ->delete();
    }

public function consultarFolio(Request $request)
    {

        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }
        $respuestas = "";
        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );


        $respuesta = [];
        try{
            $this->validateArray($request, $datos, [
                'tipo' => 'required|max:100',
                'folio' => 'required|max:100',
                'rut' => 'required|rut|max:100',
            ]);

            $documento = $this->existe_documento($datos['rut'],$datos['tipo'],$datos['folio']);
            if (is_null($documento)) {
                return $this->documentoInvalido();
            }

            $documento = DB::table('libro_ventas')
                ->select('rut as rut_empresa','fecha as fecha', 'typo_doc as tipo', 'n_doc as folio', 'rut_c as rut_cliente', 'nombre_c as razon','EXENTO_LVENTA as exento','ESPECIFICO_LVENTA as especifico','valor_n as valor_neto','valor_i as valor_iva','valor_t as valor_total')
                ->where ('rut','=',$datos['rut'])
                ->where ('typo_doc','=',$datos['tipo'])
                ->where ('n_doc','=',$datos['folio'])
                ->get();

            $datoEmisor = DB::table('datos_empresa')
                ->select('rut as rut_empresa','razon as razon','giro1 as giro','telefono as telefono','codigo1 as codigo','direccion as direcion','comuna as comuna','ciudad as ciudad')
                ->where ('rut','=',$datos['rut'])
                ->get();

            $datoReceptor = DB::table('clienteproveedor')
                ->select('RUT_CLIENTEPROVEEDOR as rut_cliente','RZ_CLIENTEPROVEEDOR as razon','GIRO_CLIENTEPROVEEDOR as giro','TELEFONO_CLIENTEPROVEEDOR as telefono')
                ->where ('RUT_EMPRESA','=',$documento[0]->rut_empresa)
                ->where ('RUT_CLIENTEPROVEEDOR','=',$documento[0]->rut_cliente)
                ->get();

            $datoReceptor_contacto = DB::table('adicional_libro_ventas')
                ->select('CONTACTO as id_contacto','MONTO_NO_FACTURABLE as monto_no_facturable')
                ->where ('RUT_EMPRESA','=',$datos['rut'])
                ->where ('typo_doc','=',$datos['tipo'])
                ->where ('n_doc','=',$datos['folio'])
                ->get();

            if (!empty($datoReceptor_contacto)) {
                // code...
                $datoReceptor_dato_contacto = DB::table('clienteproveedor_contacto')
                ->select('nombre as nombre_contacto','email as email_contacto')
                ->where ('idcontacto','=',$datoReceptor_contacto[0]->id_contacto)
                ->get();
            }

            $datoReceptor_direccion = DB::table('dir_libro_venta')
                ->select('ID_DIRECCION as id_direccion')
                ->where ('ID_EMPRESA','=',$datos['rut'])
                ->where ('FOLIO_DIR_LVENTA','=',$datos['folio'])
                ->where ('TIPO_DIR_LVENTA','=',$datos['tipo'])
                ->get();

            $datoReceptor_dato_direccion = DB::table('dir_clienteproveedor')
                ->select('DIRECCION_DIRECCION as direccion','ID_COMUNA as comuna','ID_CIUDAD as ciudad')
                ->where ('RUT_EMPRESA','=',$datos['rut'])
                ->where ('ID_DIRECCION','=',$datoReceptor_direccion[0]->id_direccion)
                ->get();

            $idDoc = array(
                "tipo"=>$documento[0]->tipo,
                "folio"=>$documento[0]->folio,
                "fechaEmis"=>$documento[0]->fecha
            );

            $emisor = array(
                'RUTEmisor' => $datoEmisor[0]->rut_empresa,
                'RznSoc' => $datoEmisor[0]->razon,
                'GiroEmis' => $datoEmisor[0]->giro,
                'Telefono' => $datoEmisor[0]->telefono,
                'Acteco' => $datoEmisor[0]->codigo,
                'DirOrigen' => $datoEmisor[0]->direcion,
                'CmnaOrigen' => $datoEmisor[0]->comuna,
                'CiudadOrigen' => $datoEmisor[0]->ciudad,
            );

            $receptor = array(
                "RUTRecep" => $datoReceptor[0]->rut_cliente,
                "RznSocRecep" => $datoReceptor[0]->razon,
                "GiroRecep" => $datoReceptor[0]->giro,
    			//"Contacto" => $datoReceptor_dato_contacto[0]->nombre_contacto,
    			//"CorreoRecep" => $datoReceptor_dato_contacto[0]->email_contacto,
                "DirRecep" => $datoReceptor_dato_direccion[0]->direccion,
                "CmnaRecep" => $datoReceptor_dato_direccion[0]->comuna,
                "CiudadRecep" => $datoReceptor_dato_direccion[0]->ciudad
            );

            $totales = array(
                "MntNeto" => $documento[0]->valor_neto,
				"MntExe" => $documento[0]->especifico,
                "TasaIVA" => "19",
                "IVA" => $documento[0]->valor_iva,
                "MntTotal" => $documento[0]->valor_total
            );

            $dato_detalle = DB::table('detalle_doc2')
                ->select('CPROD_DETALLEDOC as codigo','DETALLE_DETALLEDOC as detalle','EXENTO_DETALLEDOC as valor_exento','NETO_DETALLEDOC as valor_unitario','CANTIDAD_DETALLEDOC as cantidad','TOTAL_DETALLEDOC as total','FECHA_DETALLEDOC as id_detalle_largo')
                ->where ('RUT_EMPRESA','=',$datos['rut'])
                ->where ('ID_TIPODOC','=',$datos['tipo'])
                ->where ('ID_CORRE_DETALLEDOC','=',$datos['folio'])
                ->get();

            $dato_detalle_largo = DB::table('detalle_doc2_largo_dte')
                ->select('DETALLE_LARGO as detalle_largo')
                ->where ('RUT_EMPRESA','=',$datos['rut'])
                ->where ('TIPO_DOC','=',$datos['tipo'])
                ->where ('FOLIO','=',$datos['folio'])
                ->where ('ITEM','=',$dato_detalle[0]->id_detalle_largo)
                ->get();
                $detalle_largo = "";
                if(!empty($dato_detalle_largo[0]->detalle_largo)){
                    $detalle_largo = $dato_detalle_largo[0]->detalle_largo;
                 }else{
                    $detalle_largo = "";
                 };

            $detalle_doc = array();
            $cont = 1;
            foreach ($dato_detalle as $detalle) {
                $array_temp = array(
                    "NroLinDet" => $cont,
                    "TpoCodigo" => "",
                    "VlrCodigo" => $detalle->codigo,
					"NmbItem" => $detalle->detalle,
					"DscItem" => $detalle_largo,
                    "QtyItem" => $detalle->cantidad,
					"UnmdItem" => "UN",
                    "PrcItem" => $detalle->valor_unitario,
					"MontoItem" => $detalle->total
                );
                $cont++;
                array_push($detalle_doc,$array_temp);
            }

        } catch (ValidationException $e) {
            $respuesta[] = [$datos['rut'] => (array) $e->getResponse()->getData()];
            //continue;
        }


        $documento_array = array(
            "idDoc" => $idDoc,
            "emisor" => $emisor,
            "receptor" => $receptor,
            "totales" => $totales,
            "Detalle" => $detalle_doc
        );

        $respuestas = $documento_array;

        Logger::log(
            $usuario->rut_empresa,
            $request->path(),
            $request->method(),
            $usuario->rut_usuario,
            $datos,
            $respuestas,
            ENV('AMBIENTE_SII'),
            $request->ip()
        );

        return response()->json((array) $documento_array);
    }

    public function consultarDocumentos(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $respuesta = [];
        try{
            $this->validateArray($request, $datos, [
                'periodo' => 'required|max:4',
                'mes' => 'required|max:3',
                'rut' => 'required|rut|max:15',
            ]);

            $documentos = DB::table('libro_ventas')
                ->select('fecha as fecha', 'typo_doc as tipo', 'n_doc as folio', 'nombre_c as razon','rut as rut_empresa','valor_t as valor_total')
                ->where ('rut','=', $datos['rut'])
                ->where ('mes','=', $datos['mes']  )
                ->where ('ANO_LVENTA','=', $datos['periodo'])
                ->get();

            } catch (ValidationException $e) {
                $respuesta[] = [$doc['rut'] => (array) $e->getResponse()->getData()];
                //continue;
            }

        return response()->json((array) $documentos);
    }

    public function consultaDTE(Request $request){
        #se consulta a servidores AWS
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $respuesta = [];
        try{
            $this->validateArray($request, $datos, [
                'tipo' => 'required|numeric',
                'folio' => 'required|min:1',
                'rut' => 'required|rut|max:100',
            ]);
        }catch (ValidationException $e) {
            $respuesta[] = [$doc['rut'] => (array) $e->getResponse()->getData()];
            //continue;
        }

        #consultar servicio de abstrahere

        $xml_consulta_pdf = $this->consultaPDF($datos);


        $respuesta = $this->integrar($xml_consulta_pdf);
        //dd($respuesta);
        //$respuesta = $this->getIdEstado($respuesta);
        //$respuesta = simplexml_load_string($respuesta->IntegracionResult);

        return response()->json($respuesta);

    }

    public function consultaDTETermico(Request $request){
        
        #se consulta a servidores AWS
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $respuesta = [];
        try{
            $this->validateArray($request, $datos, [
                'tipo' => 'required|numeric',
                'folio' => 'required|min:1',
                'rut' => 'required|rut|max:100',
            ]);
        }catch (ValidationException $e) {
            $respuesta[] = [$doc['rut'] => (array) $e->getResponse()->getData()];
        }

        $metodo = "/pdfs/".$datos['rut']."/".$datos['tipo']."/".$datos['folio'].'';
        
        $api = new AbstrahereApi($usuario->rut_empresa, $usuario->rut_usuario);
        $documento = $api->GET($metodo);
        
        $documento = $api->JSON_TO_ARRAY($documento);
        $file = $documento['signedURL'];


        $respuesta = $file;

        return response()->json($respuesta);

    }

    public function limpiaRut($rut=''){
            if(!empty($rut)) {
                $rut = str_replace('-', '', str_replace('.', '', str_replace(',', '', trim($rut))));
                $rut = substr($rut, 0, -1).'-'.strtoupper(substr($rut, -1));
            }
            return $rut;

    }
    public function consultaDTEDatos(Request $request){
        #se consulta a servidores AWS
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $respuesta = [];
        try{
            $this->validateArray($request, $datos, [
                'tipo' => 'required|numeric',
                'folio' => 'required|min:1',
                'rut' => 'required|rut|max:100',
            ]);
        }catch (ValidationException $e) {
            $respuesta[] = [$doc['rut'] => (array) $e->getResponse()->getData()];
            //continue;
        }

        #consultar servicio de abstrahere

        $xml_consulta_pdf = $this->consultaPDF($datos);


        $respuesta = $this->integrar($xml_consulta_pdf);


        $respuesta = simplexml_load_string($respuesta->IntegracionResult);


        $json_string = json_encode($respuesta);
        $result_array = json_decode($json_string, TRUE);
        $url_xml_aws = $result_array['XmlDetalleConsultas']['IdDoc']['UrlsXMLEnvioSII']['UrlXMLEnvioSII'];


//        $headers 	= array('token:' . $TOKEN);
        $ch 		= curl_init();
        curl_setopt($ch,CURLOPT_URL,$url_xml_aws);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch,CURLOPT_TIMEOUT, 20);
//        curl_setopt($ch,CURLOPT_HTTPHEADER, $headers);
        $response = utf8_encode(curl_exec($ch));
        //dd($response);
        curl_close ($ch);
        //return $response;


        $respuesta = (array) simplexml_load_string($response);

        $datos['datos']['tipo'] = $respuesta['SetDTE']->DTE->Documento->Encabezado->IdDoc->TipoDTE;
        $datos['datos']['folio'] = $respuesta['SetDTE']->DTE->Documento->Encabezado->IdDoc->Folio;
        $datos['datos']['fecha_emision'] = $respuesta['SetDTE']->DTE->Documento->Encabezado->IdDoc->FchEmis;

        $datos['emisor']['rut_emisor'] = $respuesta['SetDTE']->Caratula->RutEmisor[0];

        $datos['emisor']['rut_receptor'] = $respuesta['SetDTE']->DTE->Documento->Encabezado->Receptor->RUTRecep;
        $datos['emisor']['razon'] = $respuesta['SetDTE']->DTE->Documento->Encabezado->Receptor->RznSocRecep;
        $datos['emisor']['giro'] = $respuesta['SetDTE']->DTE->Documento->Encabezado->Receptor->GiroRecep;
        $datos['emisor']['contacto'] = $respuesta['SetDTE']->DTE->Documento->Encabezado->Receptor->Contacto;
        $datos['emisor']['direccion'] = $respuesta['SetDTE']->DTE->Documento->Encabezado->Receptor->DirRecep;
        $datos['emisor']['comuna'] = $respuesta['SetDTE']->DTE->Documento->Encabezado->Receptor->CmnaRecep;


        return response()->json( $response );

    }

}
