<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

class PanelDTEController extends Controller
{
    use Autenticable;

    public function getBandejaEntrada(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        $datos = DB::table('libro_comprasr')
            ->select(
                'id as id',
                'fecha as fecha',
                'typo_doc as tipo_doc',
                'n_doc as folio',
                'rut_c as rut_proveedor',
                'nombre_c as razon',
                'valor_t as total',
            )

            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('typo_doc <> 52')
            ->whereRaw('DISPONIBLE6_LCOMPRAS = 1')
            ->get();

        return response()->json($datos);
    }

    public function getHistorial(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $item = 0;
        $respuestas = [];

        $datos = DB::table('libro_comprasr')
            ->select(
                'id as id',
                'fecha as fecha',
                'typo_doc as tipo_doc',
                'n_doc as folio',
                'rut_c as rut_proveedor',
                'nombre_c as razon',
                'valor_t as total',
            )

            ->whereRaw('rut = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('DISPONIBLE3_LCOMPRAS in(10,21,43)')
            ->whereRaw('DISPONIBLE6_LCOMPRAS in(2,0)')
            ->get();

        return response()->json($datos);
    }


}
