<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

class SistemaController extends Controller
{
    use Autenticable;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
     public function datosUsuario(Request $request)
     {
         $datos = $request->json()->all();
         $token = $request->header('token');

         $usuario = $this->valida_token($token);

         if (is_null($usuario)) {
             return $this->tokenInvalido();
         }

         $datos_usuario = DB::table('datos_usuarios')
             ->select('rut_p as rut_usuario','nombre_p as nombre','user as usuario','BODEGA as id_sucursal', 'nombre_e as email','cajero as cajero')
             ->where ('rut','=', $usuario->rut_empresa)
             ->where ('rut_p','=', $usuario->rut_usuario)
             ->get();

         $datos_usuario_admin = DB::table('Submodulos')
             ->where ('ID_EMPRESA','=', $usuario->rut_empresa)
             ->where ('ID_USUARIO','=', $usuario->rut_usuario)
             ->where ('DUB','=', 'ADMIN')
             ->count();
        $datos_usuario[0]->admin = 0;
        if ($datos_usuario_admin > 0) {
            $datos_usuario[0]->admin = 1;
        }

        foreach ($datos_usuario as $key => $d) {

            $sucursal = DB::table('sucursales')
                ->select('ID_SUCURSAL as id', 'NOMBRE_SUCURSAL as nombre','DIRECCION_SUCURSAL as direccion','ID_COMUNA as comuna','ID_CIUDAD as ciudad')
                ->where ('ID_EMPRESA','=', $usuario->rut_empresa)
                ->where ('ID_SUCURSAL','=', $d->id_sucursal)
                ->get();
            $d->sucursal = $sucursal;
            //dd($sucursal);
            //$datos_usuario->id_sucursal = $sucursal;
        }
         return response()->json((array) $datos_usuario);
     }


     public function listaUsuarios(Request $request)
     {
         $datos = $request->json()->all();
         $token = $request->header('token');

         $usuario = $this->valida_token($token);

         if (is_null($usuario)) {
             return $this->tokenInvalido();
         }

         $datos_usuario = DB::table('datos_usuarios')
             ->select('rut as rut_empresa', 'rut_p as rut_usuario','nombre_p as nombre','user as usuario','BODEGA as id_sucursal', 'nombre_e as email','cajero as cajero')
             ->where ('rut','=', $usuario->rut_empresa)
             ->get();

         $datos_usuario_admin = DB::table('Submodulos')
             ->where ('ID_EMPRESA','=', $usuario->rut_empresa)
             ->where ('ID_USUARIO','=', $usuario->rut_usuario)
             ->where ('DUB','=', 'ADMIN')
             ->count();
        $datos_usuario[0]->admin = 0;
        if ($datos_usuario_admin > 0) {
            $datos_usuario[0]->admin = 1;
        }

        foreach ($datos_usuario as $key => $d) {

            $sucursal = DB::table('sucursales')
                ->select('ID_SUCURSAL as id', 'NOMBRE_SUCURSAL as nombre','DIRECCION_SUCURSAL as direccion','ID_COMUNA as comuna','ID_CIUDAD as ciudad')
                ->where ('ID_EMPRESA','=', $usuario->rut_empresa)
                ->where ('ID_SUCURSAL','=', $d->id_sucursal)
                ->get();
            $d->sucursal = $sucursal;
        }
         return response()->json((array) $datos_usuario);
     }

     public function getUsuario(Request $request,$username)
     {
         $datos = $request->json()->all();
         $token = $request->header('token');

         $usuario = $this->valida_token($token);

         if (is_null($usuario)) {
             return $this->tokenInvalido();
         }

         $datos_usuario = DB::table('datos_usuarios')
             ->select('rut as rut_empresa', 'rut_p as rut_usuario','nombre_p as nombre','user as usuario','BODEGA as id_sucursal', 'nombre_e as email','cajero as cajero')
             ->where ('rut','=', $usuario->rut_empresa)
             ->where ('user','=', $username)
             ->get();

         $datos_usuario_admin = DB::table('Submodulos')
             ->where ('ID_EMPRESA','=', $usuario->rut_empresa)
             ->where ('ID_USUARIO','=', $usuario->rut_usuario)
             ->where ('DUB','=', 'ADMIN')
             ->count();
        $datos_usuario[0]->admin = 0;
        if ($datos_usuario_admin > 0) {
            $datos_usuario[0]->admin = 1;
        }

        foreach ($datos_usuario as $key => $d) {

            $sucursal = DB::table('sucursales')
                ->select('ID_SUCURSAL as id', 'NOMBRE_SUCURSAL as nombre','DIRECCION_SUCURSAL as direccion','ID_COMUNA as comuna','ID_CIUDAD as ciudad')
                ->where ('ID_EMPRESA','=', $usuario->rut_empresa)
                ->where ('ID_SUCURSAL','=', $d->id_sucursal)
                ->get();
            $d->sucursal = $sucursal;
        }
         return response()->json((array) $datos_usuario);
     }

     public function datosEmpresa(Request $request)
     {
         $datos = $request->json()->all();
         $token = $request->header('token');

         $usuario = $this->valida_token($token);

         if (is_null($usuario)) {
             return $this->tokenInvalido();
         }

         $datos = DB::table('datos_empresa')
             ->select(
                 'ID as id',
                 'rut as rut_empresa',
                 'razon as razon',
                 'direccion as direccion',
                 'comuna as comuna',
                 'ciudad as ciudad',
                 'PAIS as pais',
                 'telefono as telefono',
                 'web as web',
                 'unidadsii as unidad_sii',
                 'giro1 as giro1',
                 'giro2 as giro2',
                 'rut_rep1 as nombre_representante1',
                 'nombre_rep1 as rut_representante1'
                 )
             ->where ('rut','=', $usuario->rut_empresa)
             ->get();

             $datos_pais = DB::table('pais')
                 ->select('codigo as codigo')
                 ->where ('ID','=', $datos[0]->pais)
                 ->get();

            $configuracion_tipo_monto = DB::table('tipo_monto')
                ->select('tipo_doc as tipo_documento','tipo as tipo_calculo')
                ->where ('rut_empresa','=', $usuario->rut_empresa)
                ->get();

            $info_adicional = DB::table('informacion_empresa')
                ->select('descripcion','mision','vision')
                ->where ('rut_empresa','=', $usuario->rut_empresa)
                ->get();

            $info_certificado_digital = DB::table('certificados_digitales')
                ->select('fecha_inicial','fecha_expiracion','rut_certificado','nombre_certificado')
                ->where ('rut_empresa','=', $usuario->rut_empresa)
                ->get();

            $imagen_base64 = "";
            //$imagen = "http://www.softnet.cl/sistems/contabilidad/empresas/".$datos_pais[0]->codigo."A/".$usuario->rut_empresa.".jpg";

            //$imagen_base64 = base64_encode(file_get_contents($imagen));


            $datos_configuracion = array();
            foreach ($configuracion_tipo_monto as $key => $value) {
                $datos_configuracion[$value->tipo_documento] = ucfirst($value->tipo_calculo);
            }
            $datos[0] = (array) $datos[0];
            $datos[0]['certificado_digital']  = $info_certificado_digital;
            $datos[0]['configuracion_documentos']  = $datos_configuracion;
            if (!empty($info_adicional)) {
                // code...
                $datos[0]['descripcion'] = $info_adicional[0]->descripcion;
                $datos[0]['mision'] = $info_adicional[0]->mision;
                $datos[0]['vision'] = $info_adicional[0]->vision;
            }
            //$datos[0]['logo_imagen']  = $imagen_base64;
            $datos[0] = (object) $datos[0];


         return response()->json((array) $datos);
     }

public  function url_exists( $url = NULL ) {

    if( empty( $url ) ){
        return false;
    }

    $ch = curl_init( $url );

    // Establecer un tiempo de espera
    curl_setopt( $ch, CURLOPT_TIMEOUT, 5 );
    curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, 5 );

    // Establecer NOBODY en true para hacer una solicitud tipo HEAD
    curl_setopt( $ch, CURLOPT_NOBODY, true );
    // Permitir seguir redireccionamientos
    curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, true );
    // Recibir la respuesta como string, no output
    curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );

    // Descomentar si tu servidor requiere un user-agent, referrer u otra configuración específica
    // $agent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.102 Safari/537.36';
    // curl_setopt($ch, CURLOPT_USERAGENT, $agent)

    $data = curl_exec( $ch );

    // Obtener el código de respuesta
    $httpcode = curl_getinfo( $ch, CURLINFO_HTTP_CODE );
    //cerrar conexión
    curl_close( $ch );

    // Aceptar solo respuesta 200 (Ok), 301 (redirección permanente) o 302 (redirección temporal)
    $accepted_response = array( 200, 301, 302 );
    if( in_array( $httpcode, $accepted_response ) ) {
        return true;
    } else {
        return false;
    }

}

     public function logoEmpresa(Request $request)
     {
         $datos = $request->json()->all();
         $token = $request->header('token');

         $usuario = $this->valida_token($token);

         if (is_null($usuario)) {
             return $this->tokenInvalido();
         }

         $datos = DB::table('datos_empresa')
             ->select(
                 'PAIS as pais'
                 )
             ->where ('rut','=', $usuario->rut_empresa)
             ->get();

        $datos_pais = DB::table('pais')
        ->select('codigo as codigo')
        ->where ('ID','=', $datos[0]->pais)
        ->get();



        $imagen_base64 = "";
        $imagen = "http://www.softnet.cl/sistems/contabilidad/empresas/".$datos_pais[0]->codigo."/".$usuario->rut_empresa.".jpg";


        if(!$this->url_exists($imagen)){
            return "No existe logo";
        }

        $imagen_base64 = base64_encode(file_get_contents($imagen));

        return $imagen_base64;
     }


     public function datoSucursal(Request $request, $id_sucursal)
     {
         $datos = $request->json()->all();
         $token = $request->header('token');

         $usuario = $this->valida_token($token);

         if (is_null($usuario)) {
             return $this->tokenInvalido();
         }

         $datos_usuario = DB::table('sucursales')
             ->select(
                 'NOMBRE_SUCURSAL as nombre',
                 'DIRECCION_SUCURSAL as direccion',
                 'ID_COMUNA as comuna',
                 'ID_CIUDAD as comuna',
                 'TELEFONO as telefono'
             )
             ->where ('ID_EMPRESA','=', $usuario->rut_empresa)
             ->where ('ID_SUCURSAL','=', $id_sucursal)
             ->get();

         return response()->json((array) $datos_usuario);
     }

     public function obtenerConfiguracionProducto(Request $request)
     {
         $datos = $request->json()->all();
         $token = $request->header('token');

         $usuario = $this->valida_token($token);

         if (is_null($usuario)) {
             return $this->tokenInvalido();
         }

         $datos_usuario = DB::table('producto_conf')
             ->select('INVENTARIO as inventario_positivo','MOD_PRECIO as modificar_precio','DESCONTAR_X_BODEGA as descuento_por_bodega')
             ->where ('RUT_EMPRESA','=', $usuario->rut_empresa)
             ->get();

         $conf_neto_bruto = DB::table('tipo_monto')
             ->select('tipo_doc','tipo')
             ->where ('rut_empresa','=', $usuario->rut_empresa)
             ->get();
        $datos_usuario['conf'] = $conf_neto_bruto;

         return response()->json((array) $datos_usuario);
     }

     public function informacionEmpresa(Request $request)
     {
         $datos = $request->json()->all();
         $token = $request->header('token');

         $usuario = $this->valida_token($token);

         if (is_null($usuario)) {
             return $this->tokenInvalido();
         }

         $info_empresa = DB::table('informacion_empresa')
             ->select('id_informacion as id','descripcion as descripcion','mision as mision','vision as vision')
             ->where ('rut_empresa','=', $usuario->rut_empresa)
             ->get();

         return response()->json((array) $info_empresa);
     }

    //
}
