<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

class TransporteController extends Controller
{
    use Autenticable;

    public function index(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $origen_destino = DB::table('origen_destino')
            ->select(
                'id as id',
                'origen as id_origen',
                'destino as id_destino',
                'valor_base as valor',
                'id_empresa_transportista as id_empresa_transportista'
            )
            ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();

        $listado_transportes = array();
        foreach ($origen_destino as $key => $value) {

            $empresa_transportista = DB::table('empresa_tramportista')
                ->select(
                    'razon as nombre'
                )
                ->whereRaw('id = \''.$value->id_empresa_transportista.'\'')
                ->get();


            $origen = DB::table('direccion_tariafrio')
                ->select(
                    'nombre as nombre'
                )
                ->whereRaw('id = \''.$value->id_origen.'\'')
                ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
                ->get();

            $destino = DB::table('direccion_tariafrio')
                ->select(
                    'nombre as nombre'
                )
                ->whereRaw('id = \''.$value->id_destino.'\'')
                ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
                ->get();

            $pesos = DB::table('pesos_transporte')
                ->select(
                    'peso as peso',
                    'valor as valor'
                )
                ->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
                ->whereRaw('origen_destino_id = \''.$value->id.'\'')
                ->get();


            $listado_transportes[$key]['empresa'] = $empresa_transportista[0]->nombre;
            $listado_transportes[$key]['nombre_origen'] = $origen[0]->nombre;
            $listado_transportes[$key]['nombre_destino'] = $destino[0]->nombre;
            $listado_transportes[$key]['valor_base'] = $value->valor;

            $dato_peso = array();

            foreach ($pesos as $key_peso => $peso) {
                $dato_con_pesos = (array) $pesos[$key_peso];
                array_push($dato_peso, $dato_con_pesos);
            }

            $listado_transportes[$key]['valores'] =  $dato_peso;

        }

        return response()->json($listado_transportes);

    }

}
