<?php

namespace App\Models;

use DB;

class Producto {
    const PACK = 14;

    const DESCUENTO_PESO = 1;
    const DESCUENTO_PORCENTAJE = 2;

    public static function obtenProducto($codigo, $rut_emisor)
    {
        return DB::table('productos')
            ->whereRaw('ID_EMPRESA = \''.$rut_emisor.'\'')
            ->whereRaw('CODIGO_PRODUCTO = \''.$codigo.'\'')
            ->leftJoin('umedida', 'umedida.ID_UMEDIDA', '=', 'productos.ID_UMEDIDA')
            ->first();
    }

    public static function obtenTodosProducto($rut_emisor)
    {
        return DB::table('productos')
            ->select('CODIGO_PRODUCTO')
            ->whereRaw('ID_EMPRESA = \''.$rut_emisor.'\'')
            ->get();
    }
    public static function obtenTipoProducto($tipo_producto)
    {
        $tipo_producto = DB::table('tipo_producto')
            ->select('ID_TIPOPRO','NOMBRE_TIPOPRO')
            ->whereRaw('ID_TIPOPRO = \''.$tipo_producto.'\'')
            ->get();

        return $tipo_producto;

    }
    public static function obtenUnidadMedida($valor)
    {
        $resultado = DB::table('UnidadesDeMedida')
            ->select('codigo', 'descripcion', 'sigla')
            ->whereRaw('codigo = \''.$valor.'\'')
            ->get();

        return $resultado;

    }
    public static function obtenLineas($valor, $empresa)
    {
        $resultado = DB::table('producto_subfamilia')
            ->whereRaw('idsubfamilia = \''.$valor.'\'')
            ->whereRaw('rut_empresa = \''.$empresa.'\'')
            ->get();

        return $resultado;

    }
    public static function obtenfamilia($valor,$empresa)
    {
        $resultado = DB::table('producto_linea')
            ->whereRaw('idlinea = \''.$valor.'\'')
            ->whereRaw('rut_empresa = \''.$empresa.'\'')
            ->get();

        return $resultado;

    }
    public static function obtenSubfamilia($valor,$empresa)
    {

        $resultado = DB::table('familiaproductos')
            ->whereRaw('ID_FAMILIAPRODUCTOS = \''.$valor.'\'')
            ->whereRaw('ID_EMPRESA = \''.$empresa.'\'')
            ->get();

        return $resultado;

    }

    public static function obtenPackProducto($codigo, $rut_emisor)
    {
        return DB::table('pack_producto')
            ->join('productos', 'productos.ID_PRODUCTO', '=', 'pack_producto.ID_PRODUCTO')
            ->where('pack_producto.NOMBRE_PACK', '=', $codigo)
            ->where('pack_producto.RUT_EMPRESA', '=', $rut_empresa)
            ->first();
    }

    public static function calculaDescuento($precio, $tipo_descuento, $valor_descuento)
    {
        if(!empty($valor_descuento) && $valor_descuento != 0){
            if($tipo_descuento == self::DESCUENTO_PESO) {
                return $precio - $valor_descuento;
            }

            if($tipo_descuento == self::DESCUENTO_PORCENTAJE) {
                return $precio - (($precio * $valor_descuento) / 100);
            }
        }

        return $precio;
    }

    public static function configuracionProductos($rut_empresa){
        return $conf_productos = DB::table('producto_conf')
        ->select('N_MESES_COSTO','ULTIMA_GUIA_AJUSTE')
        ->whereRaw('RUT_EMPRESA = \''.strtoupper($rut_empresa).'\'')
        ->get();

    }

    public static function stock_por_producto($rut_empresa, $codigo_producto, $id_bodega=0){

        $stock = 0;

        $ingreso = DB::table('detalle_inv_productos')
        //->select('N_MESES_COSTO','ULTIMA_GUIA_AJUSTE')
        ->whereRaw('RUT_EMPRESA = \''.strtoupper($rut_empresa).'\'')
        ->whereRaw('TIPO_MOV = 1')
        ->where('CODIGO_PRODUCTO', '=', $codigo_producto)
        ->sum('detalle_inv_productos.CANTIDAD_DOC');
        //->get();


        $egreso = DB::table('detalle_inv_productos')
        //->select('N_MESES_COSTO','ULTIMA_GUIA_AJUSTE')
        ->whereRaw('RUT_EMPRESA = \''.strtoupper($rut_empresa).'\'')
        ->whereRaw('TIPO_MOV = 2')
        ->where('CODIGO_PRODUCTO', '=', $codigo_producto)
        ->sum('detalle_inv_productos.CANTIDAD_DOC');

        $stock = $ingreso - $egreso;


        return $stock;
    }


    public static function costo_prod($datos, $rut_empresa,$nuemro_meses, $costo_segun_ultima_guia_ajuste)
    {



        if(is_array($datos)){
            $cod_prod = $datos[0];
            $bodega = $datos[1];
            $virtual = $datos[2];
        }else{
            $cod_prod = $datos;
        }
        if(!empty($bodega)){
            $filtro_bodega   = " AND ID_BODEGA='$bodega'";
        }
        $and_sql = "";
        if(!empty($virtual)){
            $virtual=unserialize(base64_decode($virtual));
            $and_sql="AND ID_BODEGA IN ($virtual)";
        }

        $fecha = date("Y-m-d");

        /*$conf_productos = DB::table('producto_conf')
        ->select('N_MESES_COSTO','ULTIMA_GUIA_AJUSTE')
        ->whereRaw('RUT_EMPRESA = \''.strtoupper($rut_empresa).'\'')
        ->get();

        $nuemro_meses = $conf_productos[0]->N_MESES_COSTO;
        $costo_segun_ultima_guia_ajuste = $conf_productos[0]->ULTIMA_GUIA_AJUSTE;*/


        if($nuemro_meses > 0){
            list($year,$mon,$day) = explode('-',$fecha);
            $fecha_inicio = date('Y-m-d',mktime(0,0,0,$mon-$nuemro_meses,$day,$year));
            $AND_FECHA = " AND FECHA_INGRESO >= '$fecha_inicio'";
        }


        /*$sql_cant_meses = "SELECT N_MESES_COSTO,ULTIMA_GUIA_AJUSTE FROM `producto_conf` where RUT_EMPRESA='$empresa' ";
        $result_cant_meses = mysql_db_query($database, $sql_cant_meses);
        $rs_cant_meses = mysql_fetch_object($result_cant_meses);
        $nuemro_meses = $rs_cant_meses->N_MESES_COSTO;
        if($nuemro_meses > 0){
            list($year,$mon,$day) = explode('-',$fecha);
            $fecha_inicio = date('Y-m-d',mktime(0,0,0,$mon-$nuemro_meses,$day,$year));
            $AND_FECHA = " AND FECHA_INGRESO >= '$fecha_inicio'";
        }*/

        if($nuemro_meses > 0){
            $valor_costo = DB::table('detalle_inv_productos')
            ->whereRaw('RUT_EMPRESA = \''.strtoupper($rut_empresa).'\'')
            ->whereRaw('TIPO_MOV = 1')
            ->where('CODIGO_PRODUCTO', '=', $cod_prod)
            ->where('ADICIONAL2_DETALLE_INV', '<>', '')
            ->where('ADICIONAL2_DETALLE_INV', '<>', '0')
            ->where('FECHA_INGRESO', '>=', $fecha_inicio)
            ->avg('ADICIONAL2_DETALLE_INV');

        }else{
            $valor_costo = DB::table('detalle_inv_productos')
            ->whereRaw('RUT_EMPRESA = \''.strtoupper($rut_empresa).'\'')
            ->whereRaw('TIPO_MOV = 1')
            ->where('CODIGO_PRODUCTO', '=', $cod_prod)
            ->where('ADICIONAL2_DETALLE_INV', '<>', '')
            ->where('ADICIONAL2_DETALLE_INV', '<>', '0')
            ->avg('ADICIONAL2_DETALLE_INV');


        }


        /*$query_costo = "SELECT AVG(ADICIONAL2_DETALLE_INV) VALORIZADOV FROM  `detalle_inv_productos`  WHERE `RUT_EMPRESA`='$empresa' AND `TIPO_MOV` ='1' AND `CODIGO_PRODUCTO`='$cod_prod' AND ADICIONAL2_DETALLE_INV<>'' AND ADICIONAL2_DETALLE_INV<>'0'  $AND_FECHA $filtro_bodega $and_sql";
        $result_costo = mysql_db_query($database, $query_costo);
        $row_costo = mysql_fetch_object($result_costo);
        $valor_costo = $row_costo->VALORIZADOV;*/

        //$costo_segun_ultima_guia_ajuste = $rs_cant_meses->ULTIMA_GUIA_AJUSTE;
        if($costo_segun_ultima_guia_ajuste == 1){
    	#El order by estaba matando el index, asi que al sumarle 0 evita que caiga en ese mal plan
            $costo_guia = DB::table('detalle_inv_productos')
            ->select('ADICIONAL2_DETALLE_INV')
            ->whereRaw('RUT_EMPRESA = \''.strtoupper($rut_empresa).'\'')
            ->whereRaw('FOLIO_DOC = 500')
            ->whereRaw('TIPO_MOV = 1')
            ->whereRaw('ADICIONAL2_DETALLE_INV > 0')
            ->where('CODIGO_PRODUCTO', '=', $cod_prod)
            ->get();
            $valor_costo = $costo_guia[0]->ADICIONAL2_DETALLE_INV;
            /*$sql_costo_guia = "SELECT ADICIONAL2_DETALLE_INV FROM `detalle_inv_productos` where RUT_EMPRESA='$empresa' and FOLIO_DOC='500' and TIPO_MOV='1' and CODIGO_PRODUCTO ='$cod_prod' $filtro_bodega $and_sql AND ADICIONAL2_DETALLE_INV > '0' order by N_DOC+0 desc limit 1";
            $result_costo_guia = mysql_db_query($database, $sql_costo_guia);
            $rs_costo_guia = mysql_fetch_object($result_costo_guia);
            $valor_costo = $rs_costo_guia->ADICIONAL2_DETALLE_INV ;*/

        }

        return (int)$valor_costo;
    }
}
