<?php

namespace App\Models;

use DB;
use App\Models\Bodega;
use App\Models\Cliente;
use App\Models\FormaPago;
use App\Models\AreaNegocio;
use App\Models\Producto;
use App\Traits\Foliable;
use App\Traits\Integrable;

class Woopy {
    use Foliable;
    use Integrable;

    const BOLETA_AFECTA = 39;
    const BOLETA_EXENTA = 41;

    public function __construct(
            $id_empresa,
            $rut_empresa,
            $rut_usuario,
            $receptor,
            $razon,
            $giro,
            $telefono,
            $monto_neto,
            $monto_exento,
            $monto_no_facturable,
            $monto_iva,
            $monto_total,
            $descuento,
            $tipo_documento,
            //$area_negocio,
            $observacion,
            $direccion,
            $comuna,
            $ciudad,
            array $detalles,
            array $adicionales



        )
    {
        $this->id_empresa = $id_empresa;
        $this->rut_empresa = $rut_empresa;
        $this->rut_usuario = $rut_usuario;
        $this->receptor = $receptor;
        $this->razon = $razon;
        $this->giro = $giro;
        $this->telefono = $telefono;
        $this->monto_neto = $monto_neto;
        $this->monto_exento = $monto_exento;
        $this->monto_no_facturable = $monto_no_facturable;
        $this->monto_iva = $monto_iva;
        $this->monto_total = $monto_total;
        $this->descuento = $descuento;
        $this->tipo_documento = $tipo_documento;
        //$this->area_negocio = $area_negocio;
        $this->observacion = $observacion;
        $this->direccion = $direccion;
        $this->comuna = $comuna;
        $this->ciudad = $ciudad;
        $this->detalles = $detalles;
        $this->totalDetalle = 0;
        $this->adicionales = $adicionales;

        /*$this->montos_totales = $this->calculaTotalesBoleta(
            $this->tipo_documento,
            $this->monto_neto,
            $this->descuento
        );*/

    }

    protected function fallo($mensaje, $rollback = true, $registra_folio = true)
    {
        if($registra_folio){
            $this->registraFolioSinOcupar($this->rut_empresa, $this->tipo_documento, $this->folio);
        }
        if($rollback){
            $this->rollback();
        }
        return ['mensaje' => $mensaje];
    }

    public function ingresarWoopy()
    {

        if(is_null($this->receptor)) {
            return $this->fallo('Receptor invalido.', false, false);
        }

        //forma de pago
        $formaPago = FormaPago::obtenFormaPagoWoopy($this->rut_empresa);
        if(is_null($formaPago)) {
            return $this->fallo('Debe tener una forma de pago por defecto para woopy.', false, false);
        }
        //area de Negocio
        $areaNegocio = AreaNegocio::obtenAreaNegocioWoopy($this->rut_empresa);
        if(is_null($areaNegocio)) {
            return $this->fallo('Debe tener un Area de Negocio por defecto para woopy.', false, false);
        }

        //vendedor
        $vendedor = Vendedor::obtenVendedorWoopy($this->rut_usuario, $this->rut_empresa);
        if(is_null($vendedor)) {
            return $this->fallo('Vendedor '.$this->rut_usuario.' No configurado para woopy.', false, false);
        }


        $this->folio = $this->obtenFolio(
            $this->rut_empresa,
            $this->tipo_documento
        );

        if(is_null($this->folio)) {
            return $this->fallo('No se pudo obtener folio.', false, true);
        }

        $this->adicionales['Uno'] = isset($formaPago->NOMBRE_CPAGO) ? $formaPago->NOMBRE_CPAGO : '';
        $this->adicionales['Siete'] = isset($this->observacion) ? $this->observacion : '';
        $this->adicionales['Treintayuno'] = $this->telefono;
        $this->adicionales['Treintaydos'] = $this->monto_no_facturable;

        $datos_xml = [
            'TipoDTE' => $this->tipo_documento,
            'Folio' => $this->folio,
            'RUTEmisor' => trim(strtoupper($this->rut_empresa)),
            'RUTRecep' => trim(strtoupper($this->receptor)),
            'RznSocRecep' => $this->razon,
            'GiroRecep' => $this->giro,
            'DirRecep' => $this->direccion,
            'CmnaRecep' => $this->comuna,
            'CiudadRecep' => $this->ciudad,
            'MntNeto' => $this->monto_neto,
            'MntExento' => $this->monto_exento,
            'MntIva' => $this->monto_iva,
            'MntTotal' => $this->monto_total,
            'Detalles' => [],
        ];

        $id_ingreso_lv = $this->ingresoLibroVentas($formaPago,$areaNegocio,$vendedor);
        if(!$id_ingreso_lv){
            return $this->fallo('Excepción al ingresar datos libro ventas.');
        }

        if(!$this->ingresoCtaCte($id_ingreso_lv)){
            return $this->fallo('No se pudo realizar ingreso en ctacte.');
        }

        if ($this->descuento > 0) {
            if(!$this->ingresoDescGlobal()){
                return $this->fallo('No se pudo realizar ingreso en descuento global.');
            }
        }

        if(!$this->ingresoDirLibroVenta()){
            return $this->fallo('No se pudo realizar ingreso en direccion libro de ventas.');
        }



        if(!$this->ingresoAdicional()){
            return $this->fallo('No se pudo realizar ingreso de los campos adicionales.');
        }

        $totalDetalle = 0;
        $totalExentoDetalle = 0;
        foreach($this->detalles as $detalle){

            $bodega = Bodega::obtenBodegaWoopy($this->rut_empresa);
            if(is_null($bodega)){
                return $this->fallo('Debe tener una Bodega por defecto woopy.');
            }

            $producto = Producto::obtenProducto($detalle['Codigo'], $this->rut_empresa);
            if(is_null($producto)){
                return $this->fallo('Producto '.$detalle['Codigo'].' No existe.');
            }

            $detalle['Precio'] = !isset($detalle['Precio']) ? $producto->VALOR_PRODUCTO : $detalle['Precio'];
            //$detalle['Precio'] = $detalle['Precio'];

            if($detalle['Afecto']){
                $exento = 0;
                $neto = round(($detalle['Precio'] * $detalle['Cantidad']), 0, PHP_ROUND_HALF_UP);
                $total = round(($neto - $detalle['Descuento']), 0, PHP_ROUND_HALF_UP);
                $id_usuario = '';
                $totalDetalle += $total;
            }
            else {
                $exento = round(($detalle['Precio'] * $detalle['Cantidad']), 0, PHP_ROUND_HALF_UP);
                $neto = 0;
                $total = round(($exento - $detalle['Descuento']), 0, PHP_ROUND_HALF_UP);
                $id_usuairo = 'x';
                $totalExentoDetalle += $total;
            }

            $datos_xml['Detalles'][] = [
                'VlrCodigo' => $producto->CODIGO_PRODUCTO,
                'NmbItem' => $producto->DESCRIPCION_PRODUCTO,
                'QtyItem' => $detalle['Cantidad'],
                'UnmdItem' => $producto->NOMBRE,
                'PrcItem' => $detalle['Precio'],
                'MontoItem' => $total,
            ];

            if(!$this->ingresaDetalleDoc2($detalle, $producto, $exento, $neto, $total, $id_usuario)){
                return $this->fallo('No se pudo realizar el ingreso de detalle.');
            }

            if(!$this->ingresoDetalleInvProductos($detalle, $bodega)){
                return $this->fallo('No se pudo realizar el ingreso de detalle de inventario.');
            }


        }

        if($totalDetalle != $this->monto_neto){
            return $this->fallo('MontoNeto no coincide con sumatoria de detalles, valor debería ser: '.$totalDetalle.'.');
        }
        if($totalExentoDetalle != $this->monto_exento){
            return $this->fallo('MontoExento no coincide con sumatoria de detalles, valor debería ser: '.$totalExentoDetalle.'.');
        }

        $xml = $this->generaXmlIntegracion([
            'Rut' => $this->rut_empresa,
            'Productivo' => env('AMBIENTE_SII'),
            'Operacion' => 'procesadte',
            'AsignarFolio' => '0',
            'BoletaBasica' => $this->generaXmlBoletaBasica($datos_xml),
            'Adicionales' => $this->generaXmlAdicionales($this->adicionales),
        ]);


        $respuesta = $this->integrar($xml);
        $respuesta = simplexml_load_string($respuesta->IntegracionResult);

        if($respuesta->IdResultado != 0){
            return $this->fallo('Problemas al integrar con el SII, proceso #'.$respuesta->IdProceso.', descripcion: '.$respuesta->Descripcion.'.');
        }

        return [
            'mensaje' => 'Item guardado con exito.',
            'folio' =>  $this->folio,
            'pdf' => $respuesta->XmlDetalleConsultas->IdDoc->UrlsPDF->UrlPDF,
        ];


    }

    protected function ingresoLibroVentas($formaPago,$areaNegocio,$vendedor)
    {
        try{
        $ingreso = DB::table('libro_ventas')
            ->insertGetId([
                'rut' => $this->rut_empresa,
                'mes' => date('m', time()),
                'fecha' => date('Y-m-d', time()),
                'typo_doc' => $this->tipo_documento,
                'n_doc' => $this->folio,
                'rut_c' => strtoupper($this->receptor),
                'nombre_c' => $this->razon,
                'EXENTO_LVENTA' => $this->monto_exento,
                'DESCUENTO_LVENTA' => $this->formateaNumero($this->descuento),
                'ESPECIFICO_LVENTA' => 0,
                'valor_n' => $this->monto_neto,
                'valor_i' => $this->monto_iva,
                'IVARETENIDO_LVENTA' => 0,
                'valor_t' => $this->monto_total,
                'ANO_LVENTA' => date('Y', time()),
                'CTACTE_LVENTA' => 1,
                'FPAGO_LVENTA' => $formaPago->DIAS_CPAGO,
                'ANEGOCIO_LVENTA' => $areaNegocio->ID_AREANEGOCIO,
                'SUCURSAL_LVENTA' => 'CASA MATRIZ',
                'OBS_LVENTA' => $this->observacion,
                'DISPONIBLE1_LVENTA' => $formaPago->NOMBRE_CPAGO,
                'DISPONIBLE2_LVENTA' => $vendedor->RUT_VENDEDOR,
                'DISPONIBLE3_LVENTA' => '',
                'DISPONIBLE4_LVENTA' => '',
                'DISPONIBLE5_LVENTA' => '',
                'DISPONIBLE6_LVENTA' => date('Y-m-d', strtotime('+'.$formaPago->DIAS_CPAGO.' day', time())),
                'FINGRESO_LVENTAS' => date('Y-m-d'),
                'UINGRESO_LVENTAS' => $this->rut_usuario,
                'ID_ENVIO' => 1,
            ]);

        }catch (Exception $e) {
            return false;
        }

        return $ingreso;
    }

    protected function ingresoCtaCte($id_libro_venta)
    {
        try{
            $ingreso = DB::table('ctacte')
                ->insert([
                    'rut_empresa' => $this->rut_empresa,
                    'rut_c' => $this->receptor,
                    'n_doc_ctacte' => $this->folio,
                    'tipo_doc' => $this->formateaNumero($this->tipo_documento),
                    'total_ctacte' => $this->monto_total,
                    'pagos_ctacte' => 0,
                    'saldo_ctacte' => $this->monto_total,
                    'libro_ventas_id' => $id_libro_venta,
                ]);
        }catch (Exception $e){
            return false;
        }

        return $ingreso;
    }

    protected function ingresoDescGlobal()
    {
        try{
        $ingreso = DB::table('desc_global')
            ->insert([
                'ID_EMPRESA' => $this->rut_empresa,
                'FOLIO_DOC' => $this->folio,
                'TIPO_DOC' => $this->tipo_documento,
                'TIPO_DESC' => 2,
                'VALOR_DESC' => $this->formateaNumero($this->descuento),
                'ADICIONAL1' => '',
                'ADICIONAL2' => '',
                'ADICIONAL3' => '',
            ]);
        } catch (Exception $e){
            return false;
        }

        return $ingreso;
    }

    protected function ingresoDirLibroVenta()
    {
        try{
            $ingreso = DB::table('dir_libro_venta')
                ->insert([
                    'ID_EMPRESA' => $this->rut_empresa,
                    'FOLIO_DIR_LVENTA' => $this->folio,
                    'TIPO_DIR_LVENTA' => $this->tipo_documento,
                    'ID_DIRECCION' => $this->direccion,
                    'ADICIONAL_DIR_LVENTA' => '',
                ]);
        } catch (Exception $e){
            return false;
        }

        return $ingreso;
    }


    protected function ingresoAdicional()
    {
        try{
            $ingreso = DB::table('adicional_libro_ventas')
            ->insert([
                'RUT_EMPRESA' => $this->rut_empresa,
                'RUT_CLIENTE' => $this->receptor,
                'typo_doc' => $this->tipo_documento,
                'n_doc' => $this->folio,
                'donacion' => $this->adicionales['Treinta'],
                'MONTO_NO_FACTURABLE' => $this->monto_no_facturable,
            ]);
        } catch (Exception $e){
            return false;
        }

        return $ingreso;
    }

    protected function ingresaDetalleDoc2($detalle,$producto, $exento, $neto, $total, $id_usuario)
    {
        try{
            $ingreso = DB::table('detalle_doc2')
                ->insert([
                    'RUT_EMPRESA' => $this->rut_empresa,
                    'RUT_CLIENTE' => $this->receptor,
                    'ID_CORRE_DETALLEDOC' => $this->folio,
                    'ID_TIPODOC' => $this->tipo_documento,
                    'CPROD_DETALLEDOC' => $producto->CODIGO_PRODUCTO,
                    'DETALLE_DETALLEDOC' => $producto->DESCRIPCION_PRODUCTO,
                    'ESPECIFICO_DETALLEDOC' => '',
                    'EXENTO_DETALLEDOC' => $this->formateaNumero($exento),
                    'NETO_DETALLEDOC' => $this->formateaNumero($neto),
                    'CANTIDAD_DETALLEDOC' => $this->formateaNumero($detalle['Cantidad']),
                    'TIPODESC__DETALLEDOC' => 1,
                    'VADESC__DETALLEDOC' => $this->formateaNumero($detalle['Descuento']),
                    'DESC__DETALLEDOC' => $this->formateaNumero($detalle['Descuento']),
                    'TOTAL_DETALLEDOC' => $this->formateaNumero($total),
                    'ID_USUARIO' => $id_usuario,
                    'FECHA_DETALLEDOC' => date('Y-m-d', time()),
                    'ESTADO_DETALLEDOC' => 2,
                ]);
        } catch(Exception $e) {
            return false;
        }

        return $ingreso;
    }

    protected function ingresoDetalleInvProductos($detalle, $bodega)
    {
        try{
            $ingreso = DB::table('detalle_inv_productos')
                ->insert([
                    'CODIGO_PRODUCTO' => $detalle['Codigo'],
                    'FECHA_INGRESO' => date('Y-m-d', time()),
                    'FECHA_MOV' => date('Y-m-d H:i:s', time()),
                    'TIPO_MOV' => 2,
                    'FECHA_DOC' => date('Y-m-d', time()),
                    'FOLIO_DOC' => $this->tipo_documento,
                    'N_DOC' => $this->folio,
                    'RUT_EMPRESA' => $this->rut_empresa,
                    'OBS' => isset($this->observacion) ? $this->observacion : '',
                    'CANTIDAD_DOC' => $this->formateaNumero($detalle['Cantidad']),
                    'VALOR_PRODUCTO' => $this->formateaNumero($detalle['Precio']),
                    'ID_BODEGA' => $bodega->ID_BODEGAS,
                    'CANTIDAD_INV' => $this->formateaNumero($detalle['Cantidad']),
                    'CORRE_COMPRA' => 0,
                    'ADICIONAL1_DETALLE_INV' => $this->rut_usuario,
                ]);
        } catch(Exception $e){
            return false;
        }

        return $ingreso;
    }

    protected function calculaTotalesBoleta($tipoDocumento, $montoNeto, $descuento)
    {
        $montosTotales = [];

        if($tipoDocumento == self::BOLETA_EXENTA) {
            $montosTotales['neto'] = $montoNeto;
            $montosTotales['exento'] = $montoNeto - $descuento;
            $montosTotales['iva'] = 0;
            $montosTotales['total'] = $montosTotales['exento'];
        }
        else if($tipoDocumento == self::BOLETA_AFECTA) {
            $montosTotales['neto'] = $montoNeto;
            $montosTotales['iva'] = ($montoNeto - $descuento) * env('IVA');
            $montosTotales['total'] = ($montoNeto - $descuento) + $montosTotales['iva'];
            $montosTotales['exento'] = 0;
        }

        return $montosTotales;
    }

    protected function rollback(){
        $ingreso = DB::table('libro_ventas')
            ->whereRaw('rut = \''.$this->rut_empresa.'\'')
            ->where('typo_doc', '=', $this->tipo_documento)
            ->where('n_doc', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('ctacte')
            ->whereRaw('rut_empresa = \''.$this->rut_empresa.'\'')
            ->where('tipo_doc', '=', $this->tipo_documento)
            ->where('n_doc_ctacte', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('desc_global')
            ->whereRaw('ID_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('TIPO_DOC', '=', $this->tipo_documento)
            ->where('FOLIO_DOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('dir_libro_venta')
            ->whereRaw('ID_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('TIPO_DIR_LVENTA', '=', $this->tipo_documento)
            ->where('FOLIO_DIR_LVENTA', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('adicional_libro_ventas')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('typo_doc', '=', $this->tipo_documento)
            ->where('n_doc', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('detalle_doc2')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('ID_TIPODOC', '=', $this->tipo_documento)
            ->where('ID_CORRE_DETALLEDOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('detalle_inv_productos')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('FOLIO_DOC', '=', $this->tipo_documento)
            ->where('N_DOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('ref_sistema_ge_especial')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('ADICIONAL2', '=', $this->tipo_documento)
            ->where('ADICIONAL1', '=', $this->folio)
            ->delete();
    }

    protected function generaXmlBoletaBasica($datos)
    {
        $xml_detalle = '';

        $item = 1;
        foreach($datos['Detalles'] as $detalle) {
            $xml_detalle .= '<Detalle>
               <NroLinDet>'.$item.'</NroLinDet>
               <CdgItem>
                  <TpoCodigo />
                  <VlrCodigo>'.$detalle['VlrCodigo'].'</VlrCodigo>
               </CdgItem>
               <NmbItem>'.$detalle['NmbItem'].'</NmbItem>
               <QtyItem>'.$detalle['QtyItem'].'</QtyItem>
               <UnmdItem>'.$detalle['UnmdItem'].'</UnmdItem>
               <PrcItem>'.$detalle['PrcItem'].'</PrcItem>
               <MontoItem>'.$detalle['MontoItem'].'</MontoItem>
            </Detalle>'.PHP_EOL;
            $item++;
        }

        $giroxml = '';
        if (!empty($datos['GiroRecep'])) {
            $giroxml = '<GiroRecep>'.$datos['GiroRecep'].'</GiroRecep>';
        }

        $xml = '<DTE version="1.0">
            <Documento ID="F674T33">
               <Encabezado>
                  <IdDoc>
                     <TipoDTE>'.$datos['TipoDTE'].'</TipoDTE>
                     <Folio>'.$datos['Folio'].'</Folio>
                     <FchEmis>'.date('Y-m-d', time()).'</FchEmis>
                     <IndServicio>3</IndServicio>
                  </IdDoc>
                  <Emisor>
                     <RUTEmisor>'.$datos['RUTEmisor'].'</RUTEmisor>
                  </Emisor>
                  <Receptor>
                     <RUTRecep>'.$datos['RUTRecep'].'</RUTRecep>
                     <RznSocRecep>'.$datos['RznSocRecep'].'</RznSocRecep>
                     '.$giroxml.'
                     <DirRecep>'.$datos['DirRecep'].'</DirRecep>
                     <CmnaRecep>'.$datos['CmnaRecep'].'</CmnaRecep>
                     <CiudadRecep>'.$datos['CiudadRecep'].'</CiudadRecep>
                  </Receptor>
                  <Totales>
                      <MntNeto>'.$datos['MntNeto'].'</MntNeto>
                      <MntExe>'.$datos['MntExento'].'</MntExe>
                      <IVA>'.$datos['MntIva'].'</IVA>
                     <MntTotal>'.$datos['MntTotal'].'</MntTotal>
                  </Totales>
               </Encabezado>
               '.$xml_detalle.'
            </Documento>
         </DTE>';
         return $xml;
    }

    protected function generaXmlAdicionales($datos)
    {
        $xml = '<Adicional>
    	       <Uno>'.(isset($datos['Uno']) ? $datos['Uno'] : '').'</Uno>
    	       <Dos>'.(isset($datos['Dos']) ? $datos['Dos'] : '').'</Dos>
               <Tres>'.(isset($datos['Tres']) ? $datos['Tres'] : '').'</Tres>
               <Cuatro>'.(isset($datos['Cuatro']) ? $datos['Cuatro'] : '').'</Cuatro>
               <Cinco>'.(isset($datos['Cinco']) ? $datos['Cinco'] : '').'</Cinco>
               <Seis>'.(isset($datos['Seis']) ? $datos['Seis'] : '').'</Seis>
               <Siete>'.(isset($datos['Siete']) ? $datos['Siete'] : '').'</Siete>
               <Ocho>'.(isset($datos['Ocho']) ? $datos['Ocho'] : '').'</Ocho>
               <Nueve>'.(isset($datos['Nueve']) ? $datos['Nueve'] : '').'</Nueve>
               <Diez>'.(isset($datos['Diez']) ? $datos['Diez'] : '').'</Diez>
               <Once>'.(isset($datos['Once']) ? $datos['Once'] : '').'</Once>
               <Doce>'.(isset($datos['Doce']) ? $datos['Doce'] : '').'</Doce>
               <Trece>'.(isset($datos['Trece']) ? $datos['Trece'] : '').'</Trece>
               <Catorce>'.(isset($datos['Catorce']) ? $datos['Catorce'] : '').'</Catorce>
               <Quince>'.(isset($datos['Quince']) ? $datos['Quince'] : '').'</Quince>
               <Dieciseis>'.(isset($datos['Dieciseis']) ? $datos['Dieciseis'] : '').'</Dieciseis>
               <Diecisiete>'.(isset($datos['Diecisiete']) ? $datos['Diecisiete'] : '').'</Diecisiete>
               <Dieciocho>'.(isset($datos['Dieciocho']) ? $datos['Dieciocho'] : '').'</Dieciocho>
               <Diecinueve>'.(isset($datos['Diecinueve']) ? $datos['Diecinueve'] : '').'</Diecinueve>
               <Veinte>'.(isset($datos['Veinte']) ? $datos['Veinte'] : '').'</Veinte>
               <Veintiuno>'.(isset($datos['Veintiuno']) ? $datos['Veintiuno'] : '').'</Veintiuno>
               <Veintidos>'.(isset($datos['Veintidos']) ? $datos['Veintidos'] : '').'</Veintidos>
               <Veintitres>'.(isset($datos['Veintitres']) ? $datos['Veintitres'] : '').'</Veintitres>
               <Veinticuatro>'.(isset($datos['Veinticuatro']) ? $datos['Veinticuatro'] : '').'</Veinticuatro>
               <Veinticinco>'.(isset($datos['Veinticinco']) ? $datos['Veinticinco'] : '').'</Veinticinco>
               <Veintiseis>'.(isset($datos['Veintiseis']) ? $datos['Veintiseis'] : '').'</Veintiseis>
               <Veintisiete>'.(isset($datos['Veintisiete']) ? $datos['Veintisiete'] : '').'</Veintisiete>
               <Veintiocho>'.(isset($datos['Veintiocho']) ? $datos['Veintiocho'] : '').'</Veintiocho>
               <Veintinueve>'.(isset($datos['Veintinueve']) ? $datos['Veintinueve'] : '').'</Veintinueve>
               <Treinta>'.(isset($datos['Treinta']) ? $datos['Treinta'] : '').'</Treinta>
               <Treintayuno>'.(isset($datos['Treintayuno']) ? $datos['Treintayuno'] : '').'</Treintayuno>
               <Treintaydos>'.(isset($datos['Treintaydos']) ? $datos['Treintaydos'] : '').'</Treintaydos>
               <Treintaytres>'.(isset($datos['Treintaytres']) ? $datos['Treintaytres'] : '').'</Treintaytres>
               <Treintaycuatro>'.(isset($datos['Treintaycuatro']) ? $datos['Treintaycuatro'] : '').'</Treintaycuatro>
               <Treintaycinco>'.(isset($datos['Treintaycinco']) ? $datos['Treintaycinco'] : '').'</Treintaycinco>
               <Treintayseis>'.(isset($datos['Treintayseis']) ? $datos['Treintayseis'] : '').'</Treintayseis>
               <Treintaysiete>'.(isset($datos['Treintaysiete']) ? $datos['Treintaysiete'] : '').'</Treintaysiete>
               <Treintayocho>'.(isset($datos['Treintayocho']) ? $datos['Treintayocho'] : '').'</Treintayocho>
               <Treintaynueve>'.(isset($datos['Treintaynueve']) ? $datos['Treintaynueve'] : '').'</Treintaynueve>
               <Cuarenta>'.(isset($datos['Cuarenta']) ? $datos['Cuarenta'] : '').'</Cuarenta>
               <Cuarentayuno>'.(isset($datos['Cuarentayuno']) ? $datos['Cuarentayuno'] : '').'</Cuarentayuno>
               <Cuarentaydos>'.(isset($datos['Cuarentaydos']) ? $datos['Cuarentaydos'] : '').'</Cuarentaydos>
               <Cuarentaytres>'.(isset($datos['Cuarentaytres']) ? $datos['Cuarentaytres'] : '').'</Cuarentaytres>
               <Cuarentaycuatro>'.(isset($datos['Cuarentaycuatro']) ? $datos['Cuarentaycuatro'] : '').'</Cuarentaycuatro>
               <Cuarentaycinco>'.(isset($datos['Cuarentaycinco']) ? $datos['Cuarentaycinco'] : '').'</Cuarentaycinco>
               <Cuarentayseis>'.(isset($datos['Cuarentayseis']) ? $datos['Cuarentayseis'] : '').'</Cuarentayseis>
               <Cuarentaysiete>'.(isset($datos['Cuarentaysiete']) ? $datos['Cuarentaysiete'] : '').'</Cuarentaysiete>
               <Cuarentayocho>'.(isset($datos['Cuarentayocho']) ? $datos['Cuarentayocho'] : '').'</Cuarentayocho>
               <Cuarentaynueve>'.(isset($datos['Cuarentaynueve']) ? $datos['Cuarentaynueve'] : '').'</Cuarentaynueve>
               <Cincuenta>'.(isset($datos['Cincuenta']) ? $datos['Cincuenta'] : '').'</Cincuenta>
           </Adicional>';

       return $xml;
    }

    protected function formateaNumero($numero)
    {
        return number_format($numero, 0, ',', '');
    }
}
