<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

class ProductoLineaController extends Controller
{
    use Autenticable;

    public function index(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $datos_familia = array();

        $familia = DB::table('producto_linea')
            ->select(
                'idlinea as id',
                'nombre_linea as nombre_linea',
                'destacado as destacado',
                'estado as estado'
            )->whereRaw('rut_empresa = \''.$usuario->rut_empresa.'\'')
            ->get();


        foreach ($familia as $key => $value) {
            $estado = 0;
            if ($value->estado == 'ACTIVADA') {
                $estado = 1;
            }


            $subFamilia = (array)DB::table('familiaproductos')
            ->select(
                'ID_FAMILIAPRODUCTOS as id',
                'NOMBRE_FAMILIAPRODUCTOS as nombre_subFamilia',
                'DESCRIPCION_FAMILIAPRODUCTOS as descripcion',
                'estado as estado'
                )
                ->whereRaw('ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
                ->whereRaw('PRODUCTO_LINEA_ID = \''.$value->id.'\'')
                ->get();


            $datos = [
                'id' => $value->id,
                'nombre' => $value->nombre_linea,
                'estado' => $estado,
                'subFamilias' => $subFamilia
            ];
            array_push($datos_familia, $datos);
        }

        return response()->json($datos_familia);

    }

}
