<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;
use App\Models\Vendedor;

class VendedoresController extends Controller
{
    use Autenticable;

    public function index(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');




        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $unidades = DB::table('vendedores')
            ->select('ID_VENDEDOR as id', 'RUT_VENDEDOR as rut_vendedor','NOMBRE_VENDEDOR as nombre','ESTADO_VENDEDOR as estado','ADICIONA1_VENDEDOR as comision','ADICION2_VENDEDOR as sucursal')
            ->whereRaw('RUT_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->get();

        return response()->json((array) $unidades);
    }

    public function obtenVendedor(Request $request, $rut)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $unidades = DB::table('vendedores')
            ->select('ID_VENDEDOR as id', 'RUT_VENDEDOR as rut_vendedor','NOMBRE_VENDEDOR as nombre','ESTADO_VENDEDOR as estado','ADICIONA1_VENDEDOR as comision','ADICION2_VENDEDOR as sucursal')
            ->whereRaw('RUT_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->whereRaw('RUT_VENDEDOR = \''.$rut.'\'')
            ->get();

        return response()->json((array) $unidades);
    }

    public function actualizarVendedor(Request $request, $rut)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $this->validateJson($request, [
            'rut_vendedor' => 'required|rut|max:100',
            'nombre' => 'required|min:3|max:100',
            'estado' => 'required|integer|in:0,1',
            'sucursal' => 'required|integer',
            'comision' => 'required|integer|min:0|max:100',
         ]);

        try{
            $actualizar_vendedor = DB::table('vendedores')
                ->whereRaw('RUT_EMPRESA = \''.$usuario->rut_empresa.'\'')
                ->whereRaw('RUT_VENDEDOR = \''.$rut.'\'')
                ->update([
                    'NOMBRE_VENDEDOR' => $datos['nombre'],
                    'ESTADO_VENDEDOR' => $datos['estado'],
                    'ADICIONA1_VENDEDOR' => $datos['comision'],
                    'ADICION2_VENDEDOR' => $datos['sucursal'],
                ]);

        }catch(Exception $e) {
            $respuesta[] = [$rut => "Error al actualizar vendedor."];
            return response()->json($respuestas);
        }

        $respuesta[] = [$rut => ['mensaje' => 'Vendedor actualizado con exito.']];

        return response()->json($respuesta);
    }

    public function ingresarVendedor(Request $request)
    {
        $datos = $request->json()->all();
        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $this->validateJson($request, [
           'rut_vendedor' => 'required|rut|max:100',
           'nombre' => 'required|min:3|max:100',
           'estado' => 'required|integer|in:0,1',
           'sucursal' => 'required|integer',
           'comision' => 'required|integer|min:0|max:100',
        ]);
        $datos = $request->json()->all();


        $empresa = Vendedor::obtenVendedor($datos['rut_vendedor'], $usuario->rut_empresa);

        if (!is_null($empresa)) {

            $respuesta[] = [$datos['rut_vendedor'] => ['mensaje' => 'Vendedor ya registrado.']];
            return response()->json($respuesta);
        }

        try{
            $resultado = DB::table('vendedores')
                ->insert([
                    'ID_VENDEDOR' => null,
                    'RUT_EMPRESA' => $usuario->rut_empresa,
                    'RUT_VENDEDOR' => $datos['rut_vendedor'],
                    'NOMBRE_VENDEDOR' => $datos['nombre'],
                    'ESTADO_VENDEDOR' => $datos['estado'],
                    'ADICIONA1_VENDEDOR' => $datos['comision'],
                    'ADICION2_VENDEDOR' => $datos['sucursal'],
                ]);

        }catch(Exception $e) {
            $respuesta[] = [$datos['rut_vendedor'] => "Error al ingresar vendedor."];
            return response()->json($respuesta);
        }

        $respuesta[] = [$datos['rut_vendedor'] => ['mensaje' => 'Vendedor ingresado con exito.']];

        return response()->json($respuesta);
    }
}
