\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{informe}
[2005/01/19 v1 Estilo Memoria de Titulo - ICC - UTalca (fmeza, jperez)]

\PassOptionsToClass{12pt,oneside,fleqn,spanish}{report}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{report}}
\ProcessOptions
\LoadClass{report}

\RequirePackage[utf8]{inputenc}
\RequirePackage[english,spanish]{babel}
\RequirePackage{graphicx}
\RequirePackage{setspace}
\RequirePackage{colortbl}

\definecolor{institucional}{RGB}{0,36,105}

\selectlanguage{spanish}
%\bibliographystyle{plain}

\def\utalca{Departamento de Desarrollo}
\def\facdeing{Softnet}
\def\ciudad{Santiago}
\def\pais{Chile}


\def\resumenname{Resumen}
\def\tblcontname{Tabla de Contenidos}
\def\titulo#1{\def\@titulo{#1}}

%%%
% Redimensión de márgenes
%%%

\setlength\paperheight{11in}  %
\setlength\paperwidth{8.5in}  %
\special{papersize=8.5in,11in}

\newdimen\realleftmargin
\newdimen\realrightmargin
\newdimen\realtopmargin
\newdimen\realbottommargin
\newdimen\realheadpos

\realtopmargin    = 2.5cm
\realleftmargin   = 3cm
\realbottommargin = 2cm
\realrightmargin  = 2.5cm
\realheadpos      = 1.5cm

\setlength\oddsidemargin   {\realleftmargin}
\addtolength\oddsidemargin {-1in}

\setlength\textheight{\paperheight}
  \addtolength\textheight {-\realtopmargin}
  \addtolength\textheight {-\realbottommargin}

\setlength\textwidth{\paperwidth}
 \addtolength\textwidth {-\realleftmargin}
 \addtolength\textwidth {-\realrightmargin}

\setlength\topmargin{\realheadpos}
 \addtolength\topmargin {-1in}

\setlength\headsep{\realtopmargin}
 \addtolength\headsep{-\realheadpos}
 \addtolength\headsep{-\headheight}

%%%
% Definiciones para la tapa
%%%

\def\makeencabezado
{
\begin{center}
\onehalfspacing
{\large\bf\MakeUppercase{\utalca}} \\
{\large\MakeUppercase{\facdeing}} \\
%{\large\MakeUppercase{\escdeicc}}
\end{center}
\singlespacing
}

\def\logo
{
\begin{center}
\resizebox{8cm}{2.5cm}{\includegraphics{images/Logo.eps}}
\end{center}
}

%%%
% PORTADA
%%%

\def\maketitle
{

\singlespacing

% TAPA

\pagestyle{empty}
\setcounter{page}{-1}
\vspace*{60mm}

% Logo UTalca
\logo

% Encabezado
\makeencabezado

% Título de la memoria
\bigskip
\begin{center}
  %\onehalfspacing
  {\Large \bf \@titulo\\}
  %\singlespacing
\end{center}

% Autor
\bigskip
\begin{center}
  {\bf \MakeUppercase{\@author}}
\end{center}

\vfill

\bigskip
\bigskip
\bigskip

\newpage

\vfill

\doublespacing

\bigskip
\bigskip

%\ingcivil

%\footdate

\newpage
\pagestyle{plain} %% de ahora en adelante hay headings en las páginas
\onehalfspacing %% de ahora en adelante la separacion es de línea y 1/2
}

%%%
% Resumen
%%%

\newenvironment{resumen}{
  \addcontentsline{toc}{chapter}{\resumenname}
  \def\thepage{\csname @roman\endcsname \c@page}
  \thispagestyle{plain}
  \centerline{\bf\MakeUppercase{\resumenname}}%
  \onehalfspacing
  \vskip 2.5em
  }{

  \newpage
  \def\thepage{\csname @arabic\endcsname \c@page}
}

%%%
% Table of Contents
%%%

\renewcommand\tableofcontents{
  \addcontentsline{toc}{chapter}{\tblcontname}	%% agrega la entrada al toc
  \onehalfspacing	%% setea el espacio para el toc
  \def\thepage{\csname @roman\endcsname \c@page} %% define el estilo de numeración
  \thispagestyle{plain} %% estilo de la página
  \centerline{\bf\MakeUppercase{\tblcontname}} %% escribe \tblcontname
  \begin{flushright} \pagename \end{flushright} %% escribe \pagename
  \par
  \@starttoc{toc} %% abre el archivo y escribe el toc

  \newpage %% nueva página
  \def\thepage{\csname @arabic\endcsname \c@page} %% por si no hay mas inicio
}

%%%
% List of Tables
%%%

\renewcommand\listoftables{
  \addcontentsline{toc}{chapter}{\indtblname}
  \onehalfspacing
  \def\thepage{\csname @roman\endcsname \c@page}
  \thispagestyle{plain}
  \centerline{\bf\MakeUppercase{\indtblname}}
  \begin{flushright} \pagename \end{flushright}
  \par
  \@starttoc{lot}

  \newpage
  \def\thepage{\csname @arabic\endcsname \c@page}
}

%%%
% List of Figures
%%%

\renewcommand\listoffigures{
  \addcontentsline{toc}{chapter}{\indfigname}
  \onehalfspacing
  \def\thepage{\csname @roman\endcsname \c@page}
  \thispagestyle{plain}
  \centerline{\bf\MakeUppercase{\indfigname}}
  \begin{flushright} \pagename \end{flushright}
  \par
  \@starttoc{lof}

  \newpage
  \def\thepage{\csname @arabic\endcsname \c@page}
}

%%%
% List of Tables
%%%

\renewcommand\listoftables{
  \addcontentsline{toc}{chapter}{\indtblname}
  \onehalfspacing
  \def\thepage{\csname @roman\endcsname \c@page}
  \thispagestyle{plain}
  \centerline{\bf\MakeUppercase{\indtblname}}
  \begin{flushright} \pagename \end{flushright}
  \par
  \@starttoc{lot}

  \newpage
  \def\thepage{\csname @arabic\endcsname \c@page}
}

%%%
% Formato encabezado capítulo
%%%

\def\@makechapterhead#1{%
  \thispagestyle{plain}
  \vspace*{5mm}
  \edef\@svsec{\hbox to 0cm{\thechapter.}\hskip 1em }
  \begingroup \Huge\bf\relax
     \@hangfrom{\hskip \z@\relax\@svsec}
     {\interlinepenalty \@M {#1}\par}%
  \endgroup

  \vspace*{7mm}
  \hrule height 0pt width \textwidth

  \bigskip\bigskip\bigskip
}

\def\section{\@startsection {section}{1}{\z@}
  {-3.5ex plus -1ex minus -.2ex}
  {2.3ex plus .2ex}
  {\normalfont\large\bf}}
\def\subsection{\@startsection{subsection}{2}{\z@}
  {-3.25ex plus-1ex minus-.2ex}
  {1.5ex plus.2ex}
  {\normalfont\normalsize\bf}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}
  {-3.25ex plus -1ex minus-.2ex}
  {1.5ex plus.2ex}
  {\normalfont\normalsize\bf}}
\def\paragraph{\@startsection
  {paragraph}{4}{\z@}
  {3.25ex plus1ex minus.2ex}
  {-1em}
  {\normalfont\normalsize\bf}}
\def\subparagraph{\@startsection
  {subparagraph}{4}
  {\parindent}
  {3.25ex plus1ex minus .2ex}
  {-1em}
  {\normalfont\normalsize\bf}}

%%%
% Glosario
%%%

\newenvironment{glosario}
{
	\newpage
	\addcontentsline{toc}{chapter}{\glosname}
	\thispagestyle{plain}
	\@mkboth{\MakeUppercase\glosname}{\MakeUppercase\glosname} % marca para los headongs
  \vspace*{26mm}
  {\Huge\bf\relax\noindent {\glosname}\par}

  \bigskip\bigskip\bigskip
	\begin{description}
}
{
	\end{description}
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\appendix{\cleardoublepage
  \setcounter{section}{0}
  \secdef\@appendix\@sappendix}

  \def\@appendix[#1]#2{
  \ifnum \c@secnumdepth >-2\relax
  \refstepcounter{chapter}%
  \addcontentsline{toc}{chapter}{\Thechapter:\hspace{1em}#1}
  \else
  \addcontentsline{toc}{chapter}{#1}
  \fi
  \addtocontents{lof}%
  {\protect\addvspace{10\p@}}% Adds between-chapter space
  \addtocontents{lot}%
  {\protect\addvspace{10\p@}}% to lists of figs & tables.

  \thispagestyle{plain}
  \vspace*{25mm}
  \edef\@svsec{\hbox to 1cm{\thechapter.}\hskip 1em }
  \begingroup \Huge\bf\relax
     \@hangfrom{\hskip \z@\relax\@svsec}
     {\interlinepenalty \@M {#2}\par}%
  \endgroup

  \vspace*{7mm}
  \hrule height 2pt width \textwidth

  \bigskip\bigskip\bigskip
  \@mkboth{\MakeUppercase{\Thechapter:\hspace{1em}#1}}{\MakeUppercase{\Thechapter:\hspace{1em}#1}} % marca para los headings
  }

\def\@sappendix#1{{\centering
    \interlinepenalty \@M
    \Huge \bf
    #1\par}\@endappendix}

\endinput
