<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;
use Logger;

use App\Models\Cesion;

class CesionController extends Controller
{
	use Autenticable;


	/*
	 
    {
        "Datos": {
            "ContactoEmpresa":"",
            "UltimoVencimiento": "santiago",
            "EmailDeudor": "santiago"
        },
        "Cesionario" : {
            "Rut": "66666666-6",
            "Razon": 841,
            "Ciudad": 841,
            "Comuna": 841,
            "Direccion": 841,
            "Email": 841
        },
        "Cliente" : {
            "RutCliente": 0,
            "RazonCliente": 0,
            "MailContacto": 0
        },
        "Autorizado":{
            "Rut": "39",
            "Nombre": "39"
        },
        "Documentos" : {
            "Folio": 4549,
            "Tipo": "observacion",
            "Monto": "santiago"
        }
    }
]

	 */
	
	public function ingresarSolicitudCesion(Request $request)
	{
		$datos = $request->json()->all();
		$token = $request->header('token');

		$usuario = $this->valida_token($token);
		if (is_null($usuario)) {
			return $this->tokenInvalido();
		}

		$item = 0;
		$respuestas = [];

		Logger::log(
			$usuario->rut_empresa,
			$request->path(),
			$request->method(),
			$usuario->rut_usuario,
			$datos,
			$respuestas,
			ENV('AMBIENTE_SII'),
			$request->ip()
		);

		foreach($datos as $cesion) {
			
			$respuesta = [];
			try{
				$this->validateArray($request, $cesion, [
					'DatosEmpresaCedente' => 'required|array',
					'DatosEmpresaCedente.ContactoEmpresa' => 'required',

					'Cesionario' => 'required|array',
					'Cesionario.Rut' => 'required|rut',
					'Cesionario.Razon' => 'required|string',
					'Cesionario.Ciudad' => 'required|string',
					'Cesionario.Comuna' => 'required|string',
					'Cesionario.Direccion' => 'required|string',
					'Cesionario.Email' => 'required|string',
					'Cesionario.MailContacto' => 'required|string',

					'Autorizado' => 'required|array',
					'Autorizado.Rut' => 'required|rut',
					'Autorizado.Nombre' => 'required|string',

					'Documentos' => 'required|array',
					'Documentos.Rut' => 'required',
					'Documentos.Razon' => 'required|string',
					'Documentos.EmailDeudor' => 'required',
					'Documentos.Folio' => 'required|integer',
					'Documentos.Tipo' => 'required|integer|in:33',
					'Documentos.Monto' => 'required|integer',
					'Documentos.Vencimiento' => 'required|date'
					
				]);
			}catch(Exception $e) {
				$respuestas[$item] = (array) $e->getResponse()->getData();
				continue;
			}
			

			$data = new Cesion(
				$usuario->id_empresa,
				$usuario->rut_empresa,
				'',
				$cesion['DatosEmpresaCedente']['ContactoEmpresa'],

				$cesion['Cesionario']['Rut'],
				$cesion['Cesionario']['Razon'],
				$cesion['Cesionario']['Ciudad'],
				$cesion['Cesionario']['Comuna'],
				$cesion['Cesionario']['Direccion'],
				$cesion['Cesionario']['Email'],
				$cesion['Cesionario']['MailContacto'],
				
				$cesion['Autorizado']['Rut'],
				$cesion['Autorizado']['Nombre'],

				$cesion['Documentos']['Rut'],
				$cesion['Documentos']['Razon'],
				$cesion['Documentos']['EmailDeudor'],
				$cesion['Documentos']['Folio'],
				$cesion['Documentos']['Tipo'],
				$cesion['Documentos']['Monto'],
				$cesion['Documentos']['Vencimiento']
			);

			
			$respuestas[$item] = $data->solicitudCesion();

			Logger::log(
				$usuario->rut_empresa,
				$request->path(),
				$request->method(),
				$usuario->rut_usuario,
				json_encode($data),
				$respuestas[$item],
				ENV('AMBIENTE_SII'),
				$request->ip()
			);
		}
		return response()->json($respuestas);
	}



	public function enviaSolicitudCesion(Request $request)
	{
		$datos = $request->json()->all();
		$token = $request->header('token');

		$usuario = $this->valida_token($token);
		if (is_null($usuario)) {
			return $this->tokenInvalido();
		}

		$item = 0;
		$respuestas = [];

		/*Logger::log(
			$usuario->rut_empresa,
			$request->path(),
			$request->method(),
			$usuario->rut_usuario,
			$datos,
			$respuestas,
			ENV('AMBIENTE_SII'),
			$request->ip()
		);*/

		$respuesta = [];
		try{
			$this->validateArray($request, $datos, [
				'Rut' => 'required',
				'Tipo' => 'required|integer|in:33',
				'Folio' => 'required|integer'
				
			]);
		}catch(Exception $e) {
			$respuestas[$item] = (array) $e->getResponse()->getData();
		}
		
		

		//consultar datos de cesion
		try {
			$cesion = DB::table('cesion_documentos')
				->where('RUT_EMPRESA', '=', $usuario->rut_empresa)
				->where('RUT_CLIENTE', '=', $datos['Rut'])
				->where('TIPO_DOC', '=', $datos['Tipo'])
				->where('FOLIO_DOC', '=', $datos['Folio'])
				->get();
		} catch (Exception $e) {
			$respuestas[$item] = (array) $e->getResponse()->getData();
		}
		

		if(empty($cesion)){
			$respuestas[$item] = "Dcoumento no se encuentra disponible para ceder";
			return response()->json($respuestas);
		}
		
		$data = new Cesion(
			$usuario->id_empresa,
			$usuario->rut_empresa,
			$cesion[0]->ID,
			$cesion[0]->CONTACTO_EMPRESA,

			$cesion[0]->RUT_CESIONARIO,
			$cesion[0]->RAZON_CESIONARIO,
			$cesion[0]->CIUDAD_CESIONARIO,
			$cesion[0]->COMUNA_CESIONARIO,
			$cesion[0]->DIRECCION_CESIONARIO,
			$cesion[0]->MAIL_CESIONARIO,
			$cesion[0]->MAIL_CONTACTO,
			
			$cesion[0]->RUT_AUTORIZA,
			$cesion[0]->RAZON_AUTORIZA,

			$cesion[0]->RUT_CLIENTE,
			$cesion[0]->RAZON_CLIENTE,
			$cesion[0]->MAIL_DEUDOR,
			$cesion[0]->FOLIO_DOC,
			$cesion[0]->TIPO_DOC,
			$cesion[0]->MONTO_CEDIDO,
			$cesion[0]->VENCIMIENTO
		);

			
		$respuestas[$item] = $data->enviaCesion();
		
		Logger::log(
			$usuario->rut_empresa,
			$request->path(),
			$request->method(),
			$usuario->rut_usuario,
			json_encode($data),
			$respuestas[$item],
			ENV('AMBIENTE_SII'),
			$request->ip()
		);
		
		return response()->json($respuestas);
	}
	
	//
}
