<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;

class NoticiaController extends Controller
{
    use Autenticable;

    public function index(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $bodegas = DB::table('web_noticias')
            ->select('ID as id', 'FECHA as fecha', 'HORA as hora','TITULO as titulo','DETALLE as detalle', 'FECHA_INICIO as fecha_inicio', 'ESTADO as estado')
            ->whereRaw('ID_EMPRESA = \''.$usuario->rut_empresa.'\'')
            ->get();

        return response()->json($bodegas);
    }

    
}
