<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\Autenticable;
use DB;
use App\Models\Cliente;
use App\Models\TipoRecepcion;
use App\Traits\Foliable;

class TicketController extends Controller
{
    use Autenticable;
    use Foliable;

    public function ingresarTicket(Request $request)
    {
        $datos = $request->json()->all();

        $token = $request->header('token');

        $usuario = $this->valida_token($token);
        if (is_null($usuario)) {
            return $this->tokenInvalido();
        }

        $this->validateJson($request, [
           'rut_cliente' => 'required|rut|max:12',
           'fecha' => 'required|min:3|max:10',
           'asunto' => 'required|min:3|max:200',
           'mensaje' => 'required|min:3|max:500',
        ]);

        $cliente = Cliente::obtenCliente($datos['rut_cliente'], $usuario->rut_empresa);

        if (is_null($cliente)) {

            $respuesta[] = ['mensaje' => 'Estimado(a), el rut '.$datos['rut_cliente'].' no se ecuentra registrado en Comaco.'];
            return response()->json($respuesta);
        }

        $tipo_recepcion = TipoRecepcion::obtenTipoRecepcion($usuario->rut_empresa);

        $fecha = new \DateTime($datos['fecha']);
        $fecha = $fecha->format('Y-m-d');

        $hora = date('H:i:s');

        $tipos_permitidos = array("image/jpeg","image/jpg","image/png");

        $imagen = $datos['imagen'];

        if(!empty($imagen) && !in_array($datos['tipo_imagen'],$tipos_permitidos)){

            $respuesta[] = ['mensaje' => 'Estimado(a), Tipo '.$datos['tipo_imagen'].' no permitido. Sólo se permiten jpeg, jpg o png'];
            return response()->json($respuesta);
        }

        $folio = $this->obtenFolio($usuario->rut_empresa,3);

        try{
            $resultado = DB::table('servicio_tecnico')
                ->insert([
                    'id_servicio_tecnico' => null,
                    'rut_empresa' => $usuario->rut_empresa,
                    'id_cliente' => $cliente->ID,
                    'Id_tipo' => $tipo_recepcion->id,
                    'folio' => $folio,
                    'fecha' => $fecha,
                    'hora' => $hora,
                    'asunto' => $datos['asunto'],
                    'mensaje' => $datos['mensaje'],
                    'ruta_imagen' => $imagen,
                    'rut_usuario' => $usuario->rut_usuario,
                    'estado' => 1
                ]);

        }catch(Exception $e) {
            $respuesta[] =  ['mensaje' => 'Error al ingresar ticket.'];
            return response()->json($respuesta);
        }

        $respuesta[] = ['mensaje' => 'Ticket ingresado con éxito.'];

        $respuesta[] = ['estado' => '1'];

        $respuesta[] = ['folio' => $folio];

        return response()->json($respuesta);
    }
}
