<?php

namespace App\Models;

use DB;
use App\Traits\Abstrahere;

class Cesion {
    use Abstrahere;

    public function __construct(
            $id_empresa,
            $rut_empresa,
            $id_cesion = null,
            $contacto_empresa,

            $rut_cesionario,
            $razon_cesionario,
            $ciudad_cesionario,
            $comuna_cesionario,
            $direccion_cesionario,
            $emailCesionario,
            $mail_contacto,

            $rut_autorizado,
            $nombre_autorizado,
            
            $rut,
            $razon,
            $email_deudor,
            $folio,
            $tipo,
            $monto,
            $vencimiento
        )
    {
        $this->id_empresa = $id_empresa;
        $this->rut_empresa = $rut_empresa;
        $this->id_cesion = $id_cesion;
        $this->contacto_empresa = $contacto_empresa;
        
        $this->rut_cesionario = $rut_cesionario;
        $this->razon_cesionario = $razon_cesionario;
        $this->ciudad_cesionario = $ciudad_cesionario;
        $this->comuna_cesionario = $comuna_cesionario;
        $this->direccion_cesionario = $direccion_cesionario;
        $this->emailCesionario = $emailCesionario;
        $this->mail_contacto = $mail_contacto;
                
        $this->rut_autorizado = $rut_autorizado;
        $this->nombre_autorizado = $nombre_autorizado;
        
        $this->rut = $rut;
        $this->razon = $razon;
        $this->email_deudor = $email_deudor;
        $this->folio = $folio;
        $this->tipo = $tipo;
        $this->monto = $monto;
        $this->vencimiento = $vencimiento;
    }

    protected function fallo($mensaje, $rollback = true, $registra_folio = true)
    {
        if($rollback){
            $this->rollback();
        }
        return ['mensaje' => $mensaje];
    }

    public function solicitudCesion()
    {

        //validar datos
        //dd("validar datos");

        /**
         * Documento debe existir en BD de abstrahere
         */
        $docTributario = DB::connection('wsdtepro')
                ->table('documentotributario')
                ->select('RUTRECEPTOR','RZNSOCRECEP','MNTOTOTAL','FECHAEMIS','FECHAVENCIM')
                ->where('RUTEMISOR', '=', $this->rut_empresa)
                ->where('TIPODTE', '=', $this->tipo)
                ->where('FOLIO_SII', '=', $this->folio)
                ->get();
        if (empty($docTributario)) {
            return $this->fallo('# Documento tipo: '.$this->tipo.' folio: '.$this->folio.' No se encuentra registrado.', false, false);
        }

        /**
         * Valida que documento no exista en cesion 
         */
        $existeDocumentoEnCesion = checkDocumentoEnCesion();
        if( !$existeDocumentoEnCesion ){
            return $this->fallo('Documento ya se encuentra ingresado en cesion.');
        }


        //ingresar
        $id_ingreso_solicitud_cesion = $this->ingresoSolicitudCesion($docTributario);

        if(!$id_ingreso_solicitud_cesion){
            return $this->fallo('Excepción al ingresar datos solicitud cesion.');
        }
        
        
        return [
            'mensaje' => 'Item guardado con exito.',
            'folio' =>  $this->folio,
            'pdf' => $urlPDF,
            'timbre' =>$timbre
        ];
    }

    public function enviaCesion()
    {
        //enviar a ceder

        //validar que documento tenga datos de envio

        $datos['Rut'] = $this->rut_empresa;
        $datos['RutCesionario'] = $this->rut_cesionario;
        $datos['RazonCesionario'] = $this->razon_cesionario;
        $datos['DireccionCesionario'] = $this->direccion_cesionario;
        $datos['EmailCesionario'] = $this->emailCesionario;
        $datos['ContactoEmpresa'] = $this->mail_contacto;
        $datos['MailContacto'] = $this->mail_contacto;
        $datos['RutAutorizado'] = $this->rut_autorizado;
        $datos['NombreAutorizado'] = $this->nombre_autorizado;
        $datos['Folio'] = $this->folio;
        $datos['Tipo'] = $this->tipo;
        $datos['Monto'] = $this->monto;
        $datos['UltimoVencimiento'] = $this->vencimiento;
        $datos['EmailDeudor'] = $this->email_deudor;
        

        
        $xml_cesion = $this->generaXmlCesion($datos);

        $respuesta = (array) $this->integrar_cesion($xml_cesion);

        //$respuesta['IdResultado'];
        //$respuesta['Descripcion']

        //dd($respuesta['TrackID']);

        $this->UpdateOKCesion($respuesta);

        






        
        return [
            'Mensaje' => $respuesta['Descripcion'],
            'Tipo' => $this->tipo,
            'Folio' =>  $this->folio,
            'Monto' =>  $this->monto,
            'Track_id' =>  $respuesta['TrackID'],
            
        ];




    }


    protected function UpdateOKCesion($respuesta)
    {
        
        try{

            if($respuesta['IdResultado'] == 0){
                
                DB::table('cesion_documentos')
                ->where('ID', $this->id_cesion)
                ->update(['ESTADO' => 3]);

                /*$qup_ces = "UPDATE cesion_documentos SET ESTADO = '3' 
                WHERE ID = '$id_cesion'";
                mysql_db_query($database, $qup_ces)or die(mysql_error());*/
                
                $id_ingreso_cesion = DB::table('cesion_id')
                ->insertGetId([
                    'Id_Ces' => $this->id_cesion,
                    'Track_id' => $respuesta['TrackID'],
                    'PDF' => $respuesta['UrlXML']
                ]);
        
                /*$qid = "INSERT cesion_id (Id_Ces,Track_id,PDF)
                VALUES('$id_cesion','$track','$pdf')";
                mysql_db_query($database,$qid)or die(mysql_error());*/
            }else{
                DB::table('cesion_documentos')
                ->where('ID', $this->id_cesion)
                ->update(['ESTADO' => 11]);

                /*$qup_ces = "UPDATE cesion_documentos SET ESTADO = '11' 
                WHERE ID = '$id_cesion'";
                mysql_db_query($database, $qup_ces)or die(mysql_error());*/
                
                $id_ingreso_cesion = DB::table('cesion_error')
                ->insertGetId([
                    'Id_cE' => '',
                    'Id_Ces' => $this->id_cesion,
                    'Id_Error' => $respuesta['IdResultado'],
                    'Descripcion' => $respuesta['Descripcion']
                ]);

                /*$ins_err = "INSERT cesion_error (Id_cE,Id_Ces,Id_Error,Descripcion) 
                VALUES ('','$id_cesion','$id_error','$msje_error')";
                mysql_db_query($database, $ins_err)or die(mysql_error());*/
            }

            



            $cesion = DB::table('cesion_documentos')
            ->where('RUT_EMPRESA', '=', $this->rut_empresa)
            ->where('RUT_CLIENTE', '=', $this->rut)
            ->where('TIPO_DOC', '=', $this->tipo)
            ->where('FOLIO_DOC', '=', $this->folio)
            ->get();
        }catch (Exception $e){
            return false;
        }

        return $cesion;
    }

    protected function ingresoSolicitudCesion($docTributario)
    {

        try{
          
            $rut_C = $docTributario[0]->RUTRECEPTOR;
            $nombre_c = $docTributario[0]->RZNSOCRECEP;
            $monto = $docTributario[0]->MNTOTOTAL;
            $fecha = $docTributario[0]->FECHAEMIS;
            $fecha_v = $docTributario[0]->FECHAVENCIM;


            $fecha_act = date('Y-m-d');

            //dd($this->rut);
            
            $id_ingreso_cesion = DB::table('cesion_documentos')
            ->insertGetId([
                'RUT_EMPRESA' => $this->rut_empresa,
                'RUT_CLIENTE' => $this->rut,
                'RAZON_CLIENTE' => $this->razon,
                'RUT_CESIONARIO' => $this->rut_cesionario,
                'RAZON_CESIONARIO' => $this->razon_cesionario,
                'DIRECCION_CESIONARIO' => $this->direccion_cesionario,
                'CIUDAD_CESIONARIO' => $this->ciudad_cesionario,
                'COMUNA_CESIONARIO' => $this->comuna_cesionario,
                'MAIL_CESIONARIO' => $this->emailCesionario,
                'TIPO_DOC' => $this->tipo,
                'FOLIO_DOC' => $this->folio,
                'MONTO_CEDIDO' => $this->monto,
                'CONTACTO_EMPRESA' => $this->contacto_empresa,
                'MAIL_CONTACTO' => $this->mail_contacto,
                'RUT_AUTORIZA' => $this->rut_autorizado,
                'RAZON_AUTORIZA' => $this->nombre_autorizado,
                'VENCIMIENTO' => $this->vencimiento,
                'MAIL_DEUDOR' => $this->email_deudor,
                'ESTADO' => 1,
                'FECHA_DCTO' => $fecha,
                'FECHA_OP' => $fecha_act
            ]);
        }catch (Exception $e) {
            return false;
        }

        return $id_ingreso_cesion;
    }

    protected function checkDocumentoEnCesion()
    {
        try{
            $cesion = DB::table('cesion_documentos')
            ->where('RUT_EMPRESA', '=', $this->rut_empresa)
            ->where('RUT_CLIENTE', '=', $this->rut)
            ->where('TIPO_DOC', '=', $this->tipo)
            ->where('FOLIO_DOC', '=', $this->folio)
            ->get();
        }catch (Exception $e){
            return false;
        }

        return $cesion;
    }
    

    

    
    protected function rollback(){
        $ingreso = DB::table('cesion_documentos')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('RUT_CLIENTE', '=', $this->rut)
            ->where('TIPO_DOC', '=', $this->tipo)
            ->where('FOLIO_DOC', '=', $this->folio)
            ->delete();
    }

    
    protected function formateaNumero($numero)
    {
        return number_format($numero, 0, ',', '');
    }
}
