<?php

namespace App\Models;

use DB;
use App\Models\Bodega;
use App\Models\Cliente;
use App\Models\FormaPago;
use App\Models\AreaNegocio;
use App\Models\Producto;
use App\Traits\Foliable;
use App\Traits\Integrable;

class Prefactura {
    use Foliable;
    use Integrable;

    const Prefactura = 9;

    public function __construct(
            $id_empresa,
            $rut_empresa,
            $rut_usuario,
            $receptor,
            $areaNegocio,
            $formaPagoPrefactura,
            $observacion,
            $monto_neto,
            $monto_exento,
            array $detalles
            //array $adicionales
        )
    {
        $this->id_empresa = $id_empresa;
        $this->rut_empresa = $rut_empresa;
        $this->rut_usuario = $rut_usuario;

        $this->receptor = Cliente::obtenCliente(
            trim(strtoupper($receptor)),
            $rut_empresa
            //$direccion
        );

        $this->area_negocio = $areaNegocio;
        $this->forma_pago_prefactura = $formaPagoPrefactura;
        $this->observacion = $observacion;
        $this->monto_neto = $monto_neto;
        $this->monto_exento = $monto_exento;

        $this->tipo_documento = self::Prefactura;
        $this->detalles = $detalles;
        $this->totalDetalle = 0;
        //$this->adicionales = $adicionales;

        $this->montos_totales = $this->calculaTotalesBoleta(
            $this->tipo_documento,
            $this->monto_neto
            //$this->descuento
        );

    }

    protected function fallo($mensaje, $rollback = true, $registra_folio = true)
    {
        if($registra_folio){
            $this->registraFolioSinOcupar($this->rut_empresa, $this->tipo_documento, $this->folio);
        }
        if($rollback){
            $this->rollback();
        }
        return ['mensaje' => $mensaje];
    }

    public function ingresar()
    {

        if(is_null($this->receptor)) {
            return $this->fallo('Receptor invalido.', false, false);
        }

        $areaNegocio = AreaNegocio::obtenAreaNegocio($this->area_negocio, $this->rut_empresa);
        if(is_null($areaNegocio)) {
            return $this->fallo('Area de Negocio '.$this->area_negocio.' invalida.', false, false);
        }

        $formaPago = FormaPago::obtenFormaPagoPrefactura($this->forma_pago_prefactura);
        if(is_null($formaPago)) {
            return $this->fallo('Forma de pago pre-factura '.$this->forma_pago_prefactura.' invalida.', false, false);
        }

        $this->folio = $this->obtenFolio(
            $this->rut_empresa,
            $this->tipo_documento
        );

        if(is_null($this->folio)) {
            return $this->fallo('No se pudo obtener folio.', false, true);
        }








        //$this->adicionales['Uno'] = $formaPago->NOMBRE_CPAGO;
        $this->adicionales['Siete'] = isset($this->observacion) ? $this->observacion : '';
        //$this->adicionales['Treintayuno'] = $this->receptor->TELEFONO_CLIENTEPROVEEDOR;
        //$this->adicionales['Treintaydos'] = $this->receptor->FAX_CLIENTEPROVEEDOR;

        /*$datos_xml = [
            'TipoDTE' => $this->tipo_documento,
            'Folio' => $this->folio,
            'RUTEmisor' => trim(strtoupper($this->rut_empresa)),
            'RUTRecep' => trim(strtoupper($this->receptor->RUT_CLIENTEPROVEEDOR)),
            'RznSocRecep' => $this->receptor->RZ_CLIENTEPROVEEDOR,
            'DirRecep' => $this->receptor->DIRECCION_DIRECCION,
            'CmnaRecep' => $this->receptor->ID_COMUNA,
            'CiudadRecep' => $this->receptor->ID_CIUDAD,
            'MntNeto' => round(($this->montos_totales['neto']), 0, PHP_ROUND_HALF_UP),
            'MntExento' => round(($this->montos_totales['exento']), 0, PHP_ROUND_HALF_UP),
            'MntIva' => round(($this->montos_totales['iva']), 0, PHP_ROUND_HALF_UP),
            'MntTotal' => round(($this->montos_totales['total']), 0, PHP_ROUND_HALF_UP),
            'Detalles' => [],
        ];*/
        $ingreso_libro = $this->ingresoLibro();

        if( !$ingreso_libro ){
            return $this->fallo('Excepción al ingresar datos libro.');
        }


        /*if(!$this->ingresoCtaCte()){
            return $this->fallo('No se pudo realizar ingreso en ctacte.');
        }*/

        /*if ($this->descuento > 0) {
            if(!$this->ingresoDescGlobal()){
                return $this->fallo('No se pudo realizar ingreso en descuento global.');
            }
        }*/

        /*if(!$this->ingresoDirLibroVenta()){
            return $this->fallo('No se pudo realizar ingreso en direccion libro de ventas.');
        }*/



        $totalDetalle = 0;
        $totalExentoDetalle = 0;
        foreach($this->detalles as $detalle){

            /*$bodega = Bodega::obtenBodega($detalle['Bodega'], $this->rut_empresa);
            if(is_null($bodega)){
                return $this->fallo('Bodega '.$detalle['Bodega'].' invalida.');
            }*/

            $producto = Producto::obtenProducto($detalle['Codigo'], $this->rut_empresa);
            if(is_null($producto)){
                return $this->fallo('Producto '.$detalle['Codigo'].' No existe.');
            }

            $detalle['Precio'] = !isset($detalle['Precio']) ? $producto->VALOR_PRODUCTO : $detalle['Precio'];

            if($detalle['Afecto']){
                $exento = 0;
                $neto = round(($detalle['Precio'] * $detalle['Cantidad']), 0, PHP_ROUND_HALF_UP);
                $total = round(($neto - $detalle['Descuento']), 0, PHP_ROUND_HALF_UP);
                $id_usuario = '';
                $totalDetalle += $total;
            }
            else {
                $exento = round(($detalle['Precio'] * $detalle['Cantidad']), 0, PHP_ROUND_HALF_UP);
                $neto = 0;
                $total = round(($exento - $detalle['Descuento']), 0, PHP_ROUND_HALF_UP);
                $id_usuario = 'x';
                $totalExentoDetalle += $total;
            }

            /*$datos_xml['Detalles'][] = [
                'VlrCodigo' => $producto->CODIGO_PRODUCTO,
                'NmbItem' => $producto->DESCRIPCION_PRODUCTO,
                'QtyItem' => $detalle['Cantidad'],
                'UnmdItem' => $producto->NOMBRE,
                'PrcItem' => $detalle['Precio'],
                'MontoItem' => $total,
            ];*/

            $ingreso_detalle = $this->ingresaDetalleTicket($detalle, $producto, $exento, $neto, $total, $ingreso_libro);
            if( !$ingreso_detalle ){
                return $this->fallo('No se pudo realizar el ingreso de detalle.');
            }



            /*if(!$this->ingresoDetalleInvProductos($producto, $detalle, $bodega)){
                return $this->fallo('No se pudo realizar el ingreso de detalle de inventario.');
            }*/


        }



        if($totalDetalle != $this->monto_neto){
            return $this->fallo('MontoNeto no coincide con sumatoria de detalles, valor debería ser: '.$totalDetalle.'.');
        }
        if($totalExentoDetalle != $this->monto_exento){
            return $this->fallo('MontoExento no coincide con sumatoria de detalles, valor debería ser: '.$totalExentoDetalle.'.');
        }

        /*$xml = $this->generaXmlIntegracion([
            'Rut' => $this->rut_empresa,
            'Productivo' => env('AMBIENTE_SII'),
            'Operacion' => 'procesadte',
            'AsignarFolio' => '0',
            'BoletaBasica' => $this->generaXmlBoletaBasica($datos_xml),
            'Adicionales' => $this->generaXmlAdicionales($this->adicionales),
        ]);

        $respuesta = $this->integrar($xml);
        $respuesta = simplexml_load_string($respuesta->IntegracionResult);

        if($respuesta->IdResultado != 0){
            return $this->fallo('Problemas al integrar con el SII, proceso #'.$respuesta->IdProceso.', descripcion: '.$respuesta->Descripcion.'.');
        }
        */
        return [
            'mensaje' => 'Item guardado con exito.',
            'folio' =>  $this->folio,
            //'pdf' => $respuesta->XmlDetalleConsultas->IdDoc->UrlsPDF->UrlPDF,
        ];


    }

    protected function ingresoLibro($formaPago='')
    {
        try{
            /*$id = DB::table('users')->insertGetId(
                ['email' => 'john@example.com', 'votes' => 0]
            );*/

        $ingreso = DB::table('libro_ticket')
            ->insertGetId([
                'rut' => $this->rut_empresa,
                'mes' => date('m', time()),
                'fecha' => date('Y-m-d', time()),
                'typo_doc' => $this->tipo_documento,
                'n_doc' => $this->folio,
                'rut_c' => strtoupper($this->receptor->RUT_CLIENTEPROVEEDOR),
                'nombre_c' => $this->receptor->RZ_CLIENTEPROVEEDOR,
                'EXENTO_LVENTA' => $this->formateaNumero($this->montos_totales['exento']),
                'DESCUENTO_LVENTA' => 0,
                //'ESPECIFICO_LVENTA' => 0,
                'valor_n' => $this->formateaNumero($this->montos_totales['neto']),
                'valor_i' => $this->formateaNumero($this->montos_totales['iva']),
                //'IVARETENIDO_LVENTA' => 0,
                'valor_t' => $this->formateaNumero($this->montos_totales['total']),
                'ANO_LVENTA' => date('Y', time()),
                //'CTACTE_LVENTA' => 1,
                //'FPAGO_LVENTA' => 0,
                'ANEGOCIO_LVENTA' => $this->area_negocio,
                'SUCURSAL_LVENTA' => 'CASA MATRIZ',
                'OBS_LVENTA' => $this->observacion,
                //'DISPONIBLE1_LVENTA' => 0,
                //'DISPONIBLE2_LVENTA' => 0,
                //'DISPONIBLE3_LVENTA' => '',
                //'DISPONIBLE4_LVENTA' => '',
                //'DISPONIBLE5_LVENTA' => '',
                //'DISPONIBLE6_LVENTA' => '',
                //'FINGRESO_LVENTAS' => date('Y-m-d'),
                'usuario' => $this->rut_usuario,
                'estado' => 1,
                'datos_empresa_id' => $this->id_empresa,
            ]);

        }catch (Exception $e) {
            return false;
        }

        return $ingreso;
    }

    /*protected function ingresoCtaCte()
    {
        try{
            $ingreso = DB::table('ctacte')
                ->insert([
                    'rut_empresa' => $this->rut_empresa,
                    'rut_c' => $this->receptor->RUT_CLIENTEPROVEEDOR,
                    'n_doc_ctacte' => $this->folio,
                    'tipo_doc' => $this->formateaNumero($this->tipo_documento),
                    'total_ctacte' => $this->formateaNumero($this->montos_totales['total']),
                    'pagos_ctacte' => 0,
                    'saldo_ctacte' => $this->formateaNumero($this->montos_totales['total']),
                ]);
        }catch (Exception $e){
            return false;
        }

        return $ingreso;
    }*/

    /*protected function ingresoDescGlobal()
    {
        try{
        $ingreso = DB::table('desc_global')
            ->insert([
                'ID_EMPRESA' => $this->rut_empresa,
                'FOLIO_DOC' => $this->folio,
                'TIPO_DOC' => $this->tipo_documento,
                'TIPO_DESC' => 2,
                'VALOR_DESC' => $this->formateaNumero($this->descuento),
                'ADICIONAL1' => '',
                'ADICIONAL2' => '',
                'ADICIONAL3' => '',
            ]);
        } catch (Exception $e){
            return false;
        }

        return $ingreso;
    }*/

    /*protected function ingresoDirLibroVenta()
    {
        try{
            $ingreso = DB::table('dir_libro_venta')
                ->insert([
                    'ID_EMPRESA' => $this->rut_empresa,
                    'FOLIO_DIR_LVENTA' => $this->folio,
                    'TIPO_DIR_LVENTA' => $this->tipo_documento,
                    'ID_DIRECCION' => $this->receptor->ID_DIRECCION,
                    'ADICIONAL_DIR_LVENTA' => '',
                ]);
        } catch (Exception $e){
            return false;
        }

        return $ingreso;
    }*/


    protected function ingresaDetalleTicket($detalle, $producto, $exento, $neto, $total, $id_libro)
    {
        try{

            $ingreso = DB::table('detalle_ticket')
                ->insert([
                    'RUT_EMPRESA' => $this->rut_empresa,
                    'codigo' => $producto->CODIGO_PRODUCTO,
                    'DETALLE' => $producto->DESCRIPCION_PRODUCTO,
                    'ESPECIFICO' => '',
                    'EXENTO' => $exento,
                    'NETO' => $neto,
                    'CANTIDAD' => $detalle['Cantidad'],
                    'TIPODESC' => 1,
                    'VADESC' => $detalle['Descuento'],
                    'DESC' => $detalle['Descuento'],
                    'TOTAL' => $total,
                    'libro_ticket_id' => $id_libro
                ]);
        } catch(Exception $e) {
            return false;
        }

        return $ingreso;
    }

    protected function ingresoDetalleInvProductos($producto, $detalle, $bodega)
    {
        try{
            $ingreso = DB::table('detalle_inv_productos')
                ->insert([
                    'CODIGO_PRODUCTO' => $producto->CODIGO_PRODUCTO,
                    'FECHA_INGRESO' => date('Y-m-d', time()),
                    'FECHA_MOV' => date('Y-m-d H:i:s', time()),
                    'TIPO_MOV' => 2,
                    'FECHA_DOC' => date('Y-m-d', time()),
                    'FOLIO_DOC' => $this->tipo_documento,
                    'N_DOC' => $this->folio,
                    'RUT_EMPRESA' => $this->rut_empresa,
                    'OBS' => isset($this->observacion) ? $this->observacion : '',
                    'CANTIDAD_DOC' => $detalle['Cantidad'],
                    'VALOR_PRODUCTO' => $detalle['Precio'],
                    'ID_BODEGA' => $bodega->ID_BODEGAS,
                    'CANTIDAD_INV' => $detalle['Cantidad'],
                    'CORRE_COMPRA' => 0,
                    'ADICIONAL1_DETALLE_INV' => $this->rut_usuario,
                ]);
        } catch(Exception $e){
            return false;
        }

        return $ingreso;
    }

    protected function calculaTotalesBoleta($tipoDocumento, $montoNeto, $descuento=0)
    {
        $montosTotales = [];

        /*if($tipoDocumento == self::BOLETA_EXENTA) {
            $montosTotales['neto'] = $montoNeto;
            $montosTotales['exento'] = $montoNeto - $descuento;
            $montosTotales['iva'] = 0;
            $montosTotales['total'] = $montosTotales['exento'];
        }
        else if($tipoDocumento == self::BOLETA_AFECTA) {*/
            $montosTotales['neto'] = $montoNeto;
            $montosTotales['iva'] = ($montoNeto - $descuento) * env('IVA');
            $montosTotales['total'] = ($montoNeto - $descuento) + $montosTotales['iva'];
            $montosTotales['exento'] = 0;
        //}

        return $montosTotales;
    }

    protected function rollback(){
        $ingreso = DB::table('libro_ventas')
            ->whereRaw('rut = \''.$this->rut_empresa.'\'')
            ->where('typo_doc', '=', $this->tipo_documento)
            ->where('n_doc', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('ctacte')
            ->whereRaw('rut_empresa = \''.$this->rut_empresa.'\'')
            ->where('tipo_doc', '=', $this->tipo_documento)
            ->where('n_doc_ctacte', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('desc_global')
            ->whereRaw('ID_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('TIPO_DOC', '=', $this->tipo_documento)
            ->where('FOLIO_DOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('dir_libro_venta')
            ->whereRaw('ID_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('TIPO_DIR_LVENTA', '=', $this->tipo_documento)
            ->where('FOLIO_DIR_LVENTA', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('adicional_libro_ventas')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('typo_doc', '=', $this->tipo_documento)
            ->where('n_doc', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('detalle_doc2')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('ID_TIPODOC', '=', $this->tipo_documento)
            ->where('ID_CORRE_DETALLEDOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('detalle_inv_productos')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('FOLIO_DOC', '=', $this->tipo_documento)
            ->where('N_DOC', '=', $this->folio)
            ->delete();

        $ingreso = DB::table('ref_sistema_ge_especial')
            ->whereRaw('RUT_EMPRESA = \''.$this->rut_empresa.'\'')
            ->where('ADICIONAL2', '=', $this->tipo_documento)
            ->where('ADICIONAL1', '=', $this->folio)
            ->delete();
    }

    protected function generaXmlBoletaBasica($datos)
    {
        $xml_detalle = '';

        $item = 1;
        foreach($datos['Detalles'] as $detalle) {
            $xml_detalle .= '<Detalle>
               <NroLinDet>'.$item.'</NroLinDet>
               <CdgItem>
                  <TpoCodigo />
                  <VlrCodigo>'.$detalle['VlrCodigo'].'</VlrCodigo>
               </CdgItem>
               <NmbItem>'.$detalle['NmbItem'].'</NmbItem>
               <QtyItem>'.$detalle['QtyItem'].'</QtyItem>
               <UnmdItem>'.$detalle['UnmdItem'].'</UnmdItem>
               <PrcItem>'.$detalle['PrcItem'].'</PrcItem>
               <MontoItem>'.$detalle['MontoItem'].'</MontoItem>
            </Detalle>'.PHP_EOL;
            $item++;
        }
        $xml = '<DTE version="1.0">
            <Documento ID="F674T33">
               <Encabezado>
                  <IdDoc>
                     <TipoDTE>'.$datos['TipoDTE'].'</TipoDTE>
                     <Folio>'.$datos['Folio'].'</Folio>
                     <FchEmis>'.date('Y-m-d', time()).'</FchEmis>
                     <IndServicio>3</IndServicio>
                  </IdDoc>
                  <Emisor>
                     <RUTEmisor>'.$datos['RUTEmisor'].'</RUTEmisor>
                  </Emisor>
                  <Receptor>
                     <RUTRecep>'.$datos['RUTRecep'].'</RUTRecep>
                     <RznSocRecep>'.$datos['RznSocRecep'].'</RznSocRecep>
                     <DirRecep>'.$datos['DirRecep'].'</DirRecep>
                     <CmnaRecep>'.$datos['CmnaRecep'].'</CmnaRecep>
                     <CiudadRecep>'.$datos['CiudadRecep'].'</CiudadRecep>
                  </Receptor>
                  <Totales>
                      <MntNeto>'.$datos['MntNeto'].'</MntNeto>
                      <MntExe>'.$datos['MntExento'].'</MntExe>
                      <IVA>'.$datos['MntIva'].'</IVA>
                     <MntTotal>'.$datos['MntTotal'].'</MntTotal>
                  </Totales>
               </Encabezado>
               '.$xml_detalle.'
            </Documento>
         </DTE>';
         return $xml;
    }

    protected function generaXmlAdicionales($datos)
    {
        $xml = '<Adicional>
    	       <Uno>'.(isset($datos['Uno']) ? $datos['Uno'] : '').'</Uno>
    	       <Dos>'.(isset($datos['Dos']) ? $datos['Dos'] : '').'</Dos>
               <Tres>'.(isset($datos['Tres']) ? $datos['Tres'] : '').'</Tres>
               <Cuatro>'.(isset($datos['Cuatro']) ? $datos['Cuatro'] : '').'</Cuatro>
               <Cinco>'.(isset($datos['Cinco']) ? $datos['Cinco'] : '').'</Cinco>
               <Seis>'.(isset($datos['Seis']) ? $datos['Seis'] : '').'</Seis>
               <Siete>'.(isset($datos['Siete']) ? $datos['Siete'] : '').'</Siete>
               <Ocho>'.(isset($datos['Ocho']) ? $datos['Ocho'] : '').'</Ocho>
               <Nueve>'.(isset($datos['Nueve']) ? $datos['Nueve'] : '').'</Nueve>
               <Diez>'.(isset($datos['Diez']) ? $datos['Diez'] : '').'</Diez>
               <Once>'.(isset($datos['Once']) ? $datos['Once'] : '').'</Once>
               <Doce>'.(isset($datos['Doce']) ? $datos['Doce'] : '').'</Doce>
               <Trece>'.(isset($datos['Trece']) ? $datos['Trece'] : '').'</Trece>
               <Catorce>'.(isset($datos['Catorce']) ? $datos['Catorce'] : '').'</Catorce>
               <Quince>'.(isset($datos['Quince']) ? $datos['Quince'] : '').'</Quince>
               <Dieciseis>'.(isset($datos['Dieciseis']) ? $datos['Dieciseis'] : '').'</Dieciseis>
               <Diecisiete>'.(isset($datos['Diecisiete']) ? $datos['Diecisiete'] : '').'</Diecisiete>
               <Dieciocho>'.(isset($datos['Dieciocho']) ? $datos['Dieciocho'] : '').'</Dieciocho>
               <Diecinueve>'.(isset($datos['Diecinueve']) ? $datos['Diecinueve'] : '').'</Diecinueve>
               <Veinte>'.(isset($datos['Veinte']) ? $datos['Veinte'] : '').'</Veinte>
               <Veintiuno>'.(isset($datos['Veintiuno']) ? $datos['Veintiuno'] : '').'</Veintiuno>
               <Veintidos>'.(isset($datos['Veintidos']) ? $datos['Veintidos'] : '').'</Veintidos>
               <Veintitres>'.(isset($datos['Veintitres']) ? $datos['Veintitres'] : '').'</Veintitres>
               <Veinticuatro>'.(isset($datos['Veinticuatro']) ? $datos['Veinticuatro'] : '').'</Veinticuatro>
               <Veinticinco>'.(isset($datos['Veinticinco']) ? $datos['Veinticinco'] : '').'</Veinticinco>
               <Veintiseis>'.(isset($datos['Veintiseis']) ? $datos['Veintiseis'] : '').'</Veintiseis>
               <Veintisiete>'.(isset($datos['Veintisiete']) ? $datos['Veintisiete'] : '').'</Veintisiete>
               <Veintiocho>'.(isset($datos['Veintiocho']) ? $datos['Veintiocho'] : '').'</Veintiocho>
               <Veintinueve>'.(isset($datos['Veintinueve']) ? $datos['Veintinueve'] : '').'</Veintinueve>
               <Treinta>'.(isset($datos['Treinta']) ? $datos['Treinta'] : '').'</Treinta>
               <Treintayuno>'.(isset($datos['Treintayuno']) ? $datos['Treintayuno'] : '').'</Treintayuno>
               <Treintaydos>'.(isset($datos['Treintaydos']) ? $datos['Treintaydos'] : '').'</Treintaydos>
               <Treintaytres>'.(isset($datos['Treintaytres']) ? $datos['Treintaytres'] : '').'</Treintaytres>
               <Treintaycuatro>'.(isset($datos['Treintaycuatro']) ? $datos['Treintaycuatro'] : '').'</Treintaycuatro>
               <Treintaycinco>'.(isset($datos['Treintaycinco']) ? $datos['Treintaycinco'] : '').'</Treintaycinco>
               <Treintayseis>'.(isset($datos['Treintayseis']) ? $datos['Treintayseis'] : '').'</Treintayseis>
               <Treintaysiete>'.(isset($datos['Treintaysiete']) ? $datos['Treintaysiete'] : '').'</Treintaysiete>
               <Treintayocho>'.(isset($datos['Treintayocho']) ? $datos['Treintayocho'] : '').'</Treintayocho>
               <Treintaynueve>'.(isset($datos['Treintaynueve']) ? $datos['Treintaynueve'] : '').'</Treintaynueve>
               <Cuarenta>'.(isset($datos['Cuarenta']) ? $datos['Cuarenta'] : '').'</Cuarenta>
               <Cuarentayuno>'.(isset($datos['Cuarentayuno']) ? $datos['Cuarentayuno'] : '').'</Cuarentayuno>
               <Cuarentaydos>'.(isset($datos['Cuarentaydos']) ? $datos['Cuarentaydos'] : '').'</Cuarentaydos>
               <Cuarentaytres>'.(isset($datos['Cuarentaytres']) ? $datos['Cuarentaytres'] : '').'</Cuarentaytres>
               <Cuarentaycuatro>'.(isset($datos['Cuarentaycuatro']) ? $datos['Cuarentaycuatro'] : '').'</Cuarentaycuatro>
               <Cuarentaycinco>'.(isset($datos['Cuarentaycinco']) ? $datos['Cuarentaycinco'] : '').'</Cuarentaycinco>
               <Cuarentayseis>'.(isset($datos['Cuarentayseis']) ? $datos['Cuarentayseis'] : '').'</Cuarentayseis>
               <Cuarentaysiete>'.(isset($datos['Cuarentaysiete']) ? $datos['Cuarentaysiete'] : '').'</Cuarentaysiete>
               <Cuarentayocho>'.(isset($datos['Cuarentayocho']) ? $datos['Cuarentayocho'] : '').'</Cuarentayocho>
               <Cuarentaynueve>'.(isset($datos['Cuarentaynueve']) ? $datos['Cuarentaynueve'] : '').'</Cuarentaynueve>
               <Cincuenta>'.(isset($datos['Cincuenta']) ? $datos['Cincuenta'] : '').'</Cincuenta>
           </Adicional>';

       return $xml;
    }

    protected function formateaNumero($numero)
    {
        return number_format($numero, 0, ',', '');
    }
}
