<?php

namespace App\Traits;

use DB;
use SoapClient;

trait Abstrahere
{
    public function generaXmlCesion($datos){
        
        $xml = '<?xml version="1.0" encoding="ISO-8859-1"?>
        <Integracion>
        <Emisor>
        <Rut>'.(isset($datos['Rut']) ? $datos['Rut'] : '').'</Rut>
        <Token></Token>
        </Emisor>
        <Parametros>
        <Productivo>1</Productivo>
        <Operacion>cesiondte</Operacion>
        <AsignarFolio>0</AsignarFolio>
        <cesion>
            <!-- Rut sin punto, con guion y digito verificador de la empresa de factoring-->
            <rutcesionario>'.(isset($datos['RutCesionario']) ? $datos['RutCesionario'] : '').'</rutcesionario>
            <rznsocialcesionario>'.(isset($datos['RazonCesionario']) ? $datos['RazonCesionario'] : '').'</rznsocialcesionario>
            <direccioncesionario>'.(isset($datos['DireccionCesionario']) ? $datos['DireccionCesionario'] : '').'</direccioncesionario>
            <emailcesionario>'.(isset($datos['EmailCesionario']) ? $datos['EmailCesionario'] : '').'</emailcesionario>	<!-- contacto  y mail de la empresa cedente-->
            <contactoempresa>'.(isset($datos['ContactoEmpresa']) ? $datos['ContactoEmpresa'] : '').'</contactoempresa>
            <mailcontacto>'.(isset($datos['MailContacto']) ? $datos['MailContacto'] : '').'</mailcontacto>
            <!-- Rut sin punto, con guion y digito verificador y nombre de la persona autorizada para ceder el dte-->
            <rutautorizado>'.(isset($datos['RutAutorizado']) ? $datos['RutAutorizado'] : '').'</rutautorizado>
            <nombreautorizado>'.(isset($datos['NombreAutorizado']) ? $datos['NombreAutorizado'] : '').'</nombreautorizado>
            <!-- Folio y tipo del DTE, deberia ser solo 33. pero las guias igual pueden ser cedidas.. verificar si aplica--> 
            <folio>'.(isset($datos['Folio']) ? $datos['Folio'] : '').'</folio>
            <tipo>'.(isset($datos['Tipo']) ? $datos['Tipo'] : '').'</tipo>
            <!--monto de la cesion. para simplificar deberia ser siempre el monto total del dte-->
            <montocesion>'.(isset($datos['Monto']) ? $datos['Monto'] : '').'</montocesion>
            <!--Fecha de cobro del documento cedido en formato AAAA-MM-DD ej: 2011-02-28 -->
            <ultimovencimiento>'.(isset($datos['UltimoVencimiento']) ? $datos['UltimoVencimiento'] : '').'</ultimovencimiento>
            <!--Email de contacto de la empresa deudora.-->
            <emaildeudor>'.(isset($datos['EmailDeudor']) ? $datos['EmailDeudor'] : '').'</emaildeudor>
        </cesion>
        <DTEBasico>
        </DTEBasico>
        </Parametros>
        </Integracion>';

        return $xml;
    }

    public function generaXmlIntegracion($datos)
    {
        $xml = '<?xml version="1.0" encoding="ISO-8859-1"?>
            <Integracion>
               <Emisor>
        	       <Rut>'.(isset($datos['Rut']) ? $datos['Rut'] : '').'</Rut>
        	       <Token></Token>
               </Emisor>
               <Parametros>
        	       <Productivo>'.(isset($datos['Productivo']) ? $datos['Productivo'] : '').'</Productivo>
        	       <Operacion>'.(isset($datos['Operacion']) ? $datos['Operacion'] : '').'</Operacion>
        	       <AsignarFolio>'.(isset($datos['AsignarFolio']) ? $datos['AsignarFolio'] : '').'</AsignarFolio>
        	       <DTEBasico>'.(isset($datos['DTEBasico']) ? $datos['DTEBasico'] : '').'</DTEBasico>
                   <BoletaBasica>'.(isset($datos['BoletaBasica']) ? $datos['BoletaBasica'] : '').'</BoletaBasica>
                   <Adicionales>'.(isset($datos['Adicionales']) ? $datos['Adicionales'] : '').'</Adicionales>
        		   <IdDoc>
        		   		<TipoDTE>'.(isset($datos['TipoDTE']) ? $datos['TipoDTE'] : '').'</TipoDTE>
        		   		<Folio>'.(isset($datos['Folio']) ? $datos['Folio'] : '').'</Folio>
        		   		<RutEmisor></RutEmisor>
        		   		<EmitidoRecibido></EmitidoRecibido>
        		   		<RutReceptor></RutReceptor>
        		   		<FechaInicial></FechaInicial>
        		   		<FechaFinal></FechaFinal>
        		   		<Cedible>'.(isset($datos['Cedible']) ? $datos['Cedible'] : '').'</Cedible>
        		   		<Regenerar>1</Regenerar>
        		   </IdDoc>
               </Parametros>
           </Integracion>';

       return $xml;
    }

    public function getRespuesta($SoapClient, $_parametros){
        $result = $SoapClient->IntegracionAuth($_parametros);
        
        $xmlResult = simplexml_load_string($result->IntegracionAuthResult);

        return $xmlResult;
    }
    public function getIdEstado($respuesta){
        $id_respuesta = (array)$respuesta->IdResultado;
        return $id_respuesta[0];
    }
    public function getIdProceso($respuesta){
        $id_respuesta = (array)$respuesta->IdProceso;
        return $id_respuesta[0];
    }
    public function getDescripcion($respuesta){
        $mensaje_respuesta = (array)$respuesta->Descripcion;

        return $mensaje_respuesta[0];
    }
    public function getUrlPdf($respuesta){
        //$respuesta->XmlDetalleConsultas->IdDoc->UrlsPDF->UrlPDF
        $mensaje_respuesta = (array)$respuesta->XmlDetalleConsultas->IdDoc->UrlsPDF->UrlPDF;
        
        if (empty($mensaje_respuesta)) {
            return "PDF no disponible";
        }
        return $mensaje_respuesta[0];
        //return 'no disponible por el momento';

        //return $mensaje_respuesta;
    }
    public function getTimbre($respuesta){
        //$respuesta->XmlDetalleConsultas->IdDoc->UrlsBMP->UrlBMP
        $mensaje_respuesta = (array)$respuesta->XmlDetalleConsultas->IdDoc->UrlsBMP->UrlBMP;
        if(empty($mensaje_respuesta[0])){
            $mensaje_respuesta = '-';
        }
        
        return $mensaje_respuesta[0];
        //return $mensaje_respuesta;
    }

    public function integrar_cesion($xml){
        
        $wsdl = 'http://ws.bigdte.cl/Service.asmx?WSDL';
        $cliente = new SoapClient($wsdl,array('soap_version' => SOAP_1_2));
	    $vem 	 = $cliente->Integracion(array("StringXMLIntegracion" => utf8_encode($xml)));

        $rxml 	 = simplexml_load_string($vem->IntegracionResult);
        
        
        return $rxml;
    }

    
    public function integrar($xml)
    {

        $xml_respuesta = '';
        $_urlWebService = "https://api.bigdte.cl/v1/soap";
        $_apiKey = "eM+Gz/k/6WUFqOj3PksDBryGmKCspxrpJEcNYd6EGgc=";
        $_xmlIntegracion = $xml;



        $_parametros = array();
        $_parametros['StringXMLIntegracion'] = $_xmlIntegracion;
        $_parametros['stream_context'] = stream_context_create([
        	'http' => array('header' => "x-api-key:$_apiKey")
        ]);
        $_soapClient = new SoapClient($_urlWebService, $_parametros);

        $respuesta = $this->getRespuesta($_soapClient, $_parametros);

        $xml_respuesta = $respuesta;

        return $xml_respuesta;
    }

    public function consultaPDF($datos)
    {
        $xml_consulta_pdf = '<?xml version="1.0" encoding="ISO-8859-1"?>
        <Integracion>
        <Emisor>
        <Rut>'.(isset($datos['rut']) ? $datos['rut'] : '').'</Rut>
        <Token />
        </Emisor>
        <Parametros>
        <Productivo>1</Productivo>
        <Operacion>consultapdf</Operacion>
        <AsignarFolio>0</AsignarFolio>
        <IdDoc>
        <TipoDTE>'.(isset($datos['tipo']) ? $datos['tipo'] : '').'</TipoDTE>
        <Folio>'.(isset($datos['folio']) ? $datos['folio'] : '').'</Folio>
        <RutEmisor/>
        <EmitidoRecibido>E</EmitidoRecibido>
        <RutReceptor />
        <FechaInicial />
        <FechaFinal />
        <Cedible>'.(isset($datos['cedible']) ? $datos['cedible'] : '').'</Cedible>
        <TipoImpreso></TipoImpreso>
        <Regenerar>1</Regenerar>
        </IdDoc>
        <cesion>
        <rutcesionario>
        </rutcesionario>
        <rznsocialcesionario>
        </rznsocialcesionario>
        <direccioncesionario>
        </direccioncesionario>
        <emailcesionario>
        </emailcesionario>
        <contactoempresa>
        </contactoempresa>
        <mailcontacto>
        </mailcontacto>
        <rutautorizado>
        </rutautorizado>
        <nombreautorizado>
        </nombreautorizado>
        <folio>
        </folio>
        <tipo>
        </tipo>
        <montocesion>
        </montocesion>
        <ultimovencimiento>
        </ultimovencimiento>
        <emaildeudor>
        </emaildeudor>
        </cesion>
        <DTEBasico>
        </DTEBasico>
        <RecepcionDTEs>
        <FechaRecepcionInicial>
        </FechaRecepcionInicial>
        <FechaRecepcionFinal>
        </FechaRecepcionFinal>
        </RecepcionDTEs>
        <recibidosensii>
        </recibidosensii>
        <Adicionales>
        </Adicionales>
        <CAFSII />
        <IdLibro>
        <TipoOperacion />
        <Tipolibro />
        <TipoEnvio />
        <Periodo />
        <FolioNotificacion />
        <CodAutRec />
        <FechaInicial />
        <FechaFinal />
        <FolioInicial />
        <FolioFinal />
        <RutReceptor />
        <TposDocEspecial />
        </IdLibro>
        <LibroCSV />
        <cedente>
        <rutcedente />
        <rznsoccedente />
        <rutautorizado />
        <nombreautorizado />
        <passwordPFX />
        <firmabinbase64 />
        <passwordcedente />
        </cedente>
        </Parametros>
        </Integracion>';

        return $xml_consulta_pdf;
    }
}
